/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.jelly.AbstractStaplerTag;
import org.xml.sax.SAXException;

public class CopyStreamTag
extends AbstractStaplerTag {
    private Reader in;
    private static final char[] CHARS_LE = "&lt;".toCharArray();
    private static final char[] CHARS_AMP = "&amp;".toCharArray();

    public void setReader(Reader in) {
        this.in = in;
    }

    public void setInputStream(InputStream in) {
        this.in = new InputStreamReader(in);
    }

    public void setFile(File f) throws FileNotFoundException {
        this.in = new FileReader(f);
    }

    public void setUrl(URL url) throws IOException {
        this.setInputStream(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        if (this.in == null) {
            return;
        }
        char[] buf = new char[8192];
        try {
            try {
                int len;
                while ((len = this.in.read(buf, 0, buf.length)) >= 0) {
                    int last = 0;
                    block11: for (int i = 0; i < len; ++i) {
                        char ch = buf[i];
                        switch (ch) {
                            case '<': {
                                xmlOutput.characters(buf, last, i - last);
                                xmlOutput.characters(CHARS_LE, 0, CHARS_LE.length);
                                last = i + 1;
                                continue block11;
                            }
                            case '&': {
                                xmlOutput.characters(buf, last, i - last);
                                xmlOutput.characters(CHARS_AMP, 0, CHARS_AMP.length);
                                last = i + 1;
                            }
                        }
                    }
                    xmlOutput.characters(buf, last, len - last);
                }
            }
            finally {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
    }
}

