/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.eclipse.jetty.websocket.common.message.MessageWriter;
import org.eclipse.jetty.websocket.common.util.TextUtil;
import org.eclipse.jetty.websocket.jsr356.AbstractJsrRemote;
import org.eclipse.jetty.websocket.jsr356.JsrSession;

public class JsrBasicRemote
extends AbstractJsrRemote
implements RemoteEndpoint.Basic {
    private static final Logger LOG = Log.getLogger(JsrBasicRemote.class);

    protected JsrBasicRemote(JsrSession session) {
        super(session);
    }

    public OutputStream getSendStream() throws IOException {
        return new MessageOutputStream(this.session);
    }

    public Writer getSendWriter() throws IOException {
        return new MessageWriter(this.session);
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", BufferUtil.toDetailString(data));
        }
        this.jettyRemote.sendBytes(data);
    }

    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialByte);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", BufferUtil.toDetailString(partialByte), isLast);
        }
        this.jettyRemote.sendPartialBytes(partialByte, isLast);
    }

    public void sendObject(Object data) throws IOException, EncodeException {
        Future<Void> fut = this.sendObjectViaFuture(data);
        try {
            fut.get();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to write object", e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to write object", e);
        }
    }

    public void sendText(String text) throws IOException {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", TextUtil.hint(text));
        }
        this.jettyRemote.sendString(text);
    }

    public void sendText(String partialMessage, boolean isLast) throws IOException {
        this.assertMessageNotNull(partialMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", TextUtil.hint(partialMessage), isLast);
        }
        this.jettyRemote.sendPartialString(partialMessage, isLast);
    }
}

