/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.nosql.mongodb.MongoSessionManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class MongoSessionIdManager
extends AbstractSessionIdManager {
    private static final Logger __log = Log.getLogger((String)"org.eclipse.jetty.server.session");
    static final DBObject __version_1 = new BasicDBObject("__metadata__.version", (Object)1);
    static final DBObject __valid_false = new BasicDBObject("valid", (Object)false);
    static final DBObject __valid_true = new BasicDBObject("valid", (Object)true);
    static final long __defaultScavengePeriod = 1800000L;
    final DBCollection _sessions;
    protected Server _server;
    private Scheduler _scheduler;
    private boolean _ownScheduler;
    private Scheduler.Task _scavengerTask;
    private Scheduler.Task _purgerTask;
    private long _scavengePeriod = 1800000L;
    private boolean _purge = true;
    private long _purgeDelay = 86400000L;
    private long _purgeInvalidAge = 86400000L;
    private long _purgeValidAge = 604800000L;
    protected final Set<String> _sessionsIds = new HashSet<String>();

    public MongoSessionIdManager(Server server) throws UnknownHostException, MongoException {
        this(server, new Mongo().getDB("HttpSessions").getCollection("sessions"));
    }

    public MongoSessionIdManager(Server server, DBCollection sessions) {
        super(new Random());
        this._server = server;
        this._sessions = sessions;
        DBObject idKey = BasicDBObjectBuilder.start().add("id", (Object)1).get();
        this._sessions.createIndex(idKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1").add("ns", (Object)this._sessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        DBObject versionKey = BasicDBObjectBuilder.start().add("id", (Object)1).add("version", (Object)1).get();
        this._sessions.createIndex(versionKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1_version_1").add("ns", (Object)this._sessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        long now = System.currentTimeMillis();
        __log.debug("SessionIdManager:scavenge:at {}", now);
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            BasicDBObject query = new BasicDBObject();
            query.put("id", (Object)new BasicDBObject("$in", this._sessionsIds));
            query.put("expiry", (Object)new BasicDBObject("$gt", (Object)0));
            query.put("expiry", (Object)new BasicDBObject("$lt", (Object)now));
            DBCursor checkSessions = this._sessions.find((DBObject)query, (DBObject)new BasicDBObject("id", (Object)1));
            for (DBObject session : checkSessions) {
                __log.debug("SessionIdManager:scavenge: expiring session {}", new Object[]{(String)session.get("id")});
                this.expireAll((String)session.get("id"));
            }
        }
    }

    protected void scavengeFully() {
        __log.debug("SessionIdManager:scavengeFully", new Object[0]);
        DBCursor checkSessions = this._sessions.find();
        for (DBObject session : checkSessions) {
            this.expireAll((String)session.get("id"));
        }
    }

    protected void purge() {
        __log.debug("PURGING", new Object[0]);
        BasicDBObject invalidQuery = new BasicDBObject();
        invalidQuery.put("accessed", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - this._purgeInvalidAge)));
        invalidQuery.put("valid", (Object)false);
        DBCursor oldSessions = this._sessions.find((DBObject)invalidQuery, (DBObject)new BasicDBObject("id", (Object)1));
        for (DBObject session : oldSessions) {
            String id = (String)session.get("id");
            __log.debug("MongoSessionIdManager:purging invalid session {}", new Object[]{id});
            this._sessions.remove(session);
        }
        if (this._purgeValidAge != 0L) {
            BasicDBObject validQuery = new BasicDBObject();
            validQuery.put("accessed", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - this._purgeValidAge)));
            validQuery.put("valid", (Object)true);
            oldSessions = this._sessions.find((DBObject)validQuery, (DBObject)new BasicDBObject("id", (Object)1));
            for (DBObject session : oldSessions) {
                String id = (String)session.get("id");
                __log.debug("MongoSessionIdManager:purging valid session {}", new Object[]{id});
                this._sessions.remove(session);
            }
        }
    }

    protected void purgeFully() {
        BasicDBObject invalidQuery = new BasicDBObject();
        invalidQuery.put("valid", (Object)false);
        DBCursor oldSessions = this._sessions.find((DBObject)invalidQuery, (DBObject)new BasicDBObject("id", (Object)1));
        for (DBObject session : oldSessions) {
            String id = (String)session.get("id");
            __log.debug("MongoSessionIdManager:purging invalid session {}", new Object[]{id});
            this._sessions.remove(session);
        }
    }

    public DBCollection getSessions() {
        return this._sessions;
    }

    public boolean isPurgeEnabled() {
        return this._purge;
    }

    public void setPurge(boolean purge) {
        this._purge = purge;
    }

    public void setScavengePeriod(long scavengePeriod) {
        this._scavengePeriod = scavengePeriod <= 0L ? 1800000L : TimeUnit.SECONDS.toMillis(scavengePeriod);
    }

    public void setPurgeDelay(long purgeDelay) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._purgeDelay = purgeDelay;
    }

    public long getPurgeInvalidAge() {
        return this._purgeInvalidAge;
    }

    public void setPurgeInvalidAge(long purgeValidAge) {
        this._purgeInvalidAge = purgeValidAge;
    }

    public long getPurgeValidAge() {
        return this._purgeValidAge;
    }

    public void setPurgeValidAge(long purgeValidAge) {
        this._purgeValidAge = purgeValidAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        __log.debug("MongoSessionIdManager:starting", new Object[0]);
        MongoSessionIdManager mongoSessionIdManager = this;
        synchronized (mongoSessionIdManager) {
            this._scheduler = (Scheduler)this._server.getBean(Scheduler.class);
            if (this._scheduler == null) {
                this._scheduler = new ScheduledExecutorScheduler();
                this._ownScheduler = true;
                this._scheduler.start();
            } else if (!this._scheduler.isStarted()) {
                throw new IllegalStateException("Shared scheduler not started");
            }
            if (this._scavengePeriod > 0L) {
                if (this._scavengerTask != null) {
                    this._scavengerTask.cancel();
                    this._scavengerTask = null;
                }
                this._scavengerTask = this._scheduler.schedule((Runnable)new Scavenger(), this._scavengePeriod, TimeUnit.MILLISECONDS);
            } else if (__log.isDebugEnabled()) {
                __log.debug("Scavenger disabled", new Object[0]);
            }
            if (this._purge) {
                if (this._purgerTask != null) {
                    this._purgerTask.cancel();
                    this._purgerTask = null;
                }
                this._purgerTask = this._scheduler.schedule((Runnable)new Purger(), this._purgeDelay, TimeUnit.MILLISECONDS);
            } else if (__log.isDebugEnabled()) {
                __log.debug("Purger disabled", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        MongoSessionIdManager mongoSessionIdManager = this;
        synchronized (mongoSessionIdManager) {
            if (this._scavengerTask != null) {
                this._scavengerTask.cancel();
                this._scavengerTask = null;
            }
            if (this._purgerTask != null) {
                this._purgerTask.cancel();
                this._purgerTask = null;
            }
            if (this._ownScheduler && this._scheduler != null) {
                this._scheduler.stop();
                this._scheduler = null;
            }
        }
        super.doStop();
    }

    public boolean idInUse(String sessionId) {
        DBObject o = this._sessions.findOne((DBObject)new BasicDBObject("id", (Object)sessionId), __valid_true);
        if (o != null) {
            Boolean valid = (Boolean)o.get("valid");
            if (valid == null) {
                return false;
            }
            return valid;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(HttpSession session) {
        if (session == null) {
            return;
        }
        __log.debug("MongoSessionIdManager:addSession {}", new Object[]{session.getId()});
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.add(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(HttpSession session) {
        if (session == null) {
            return;
        }
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.remove(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(String sessionId) {
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.remove(sessionId);
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof MongoSessionManager)) continue;
                ((MongoSessionManager)manager).invalidateSession(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAll(String sessionId) {
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.remove(sessionId);
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof MongoSessionManager)) continue;
                ((MongoSessionManager)manager).expire(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.remove(oldClusterId);
            this._sessionsIds.add(newClusterId);
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof MongoSessionManager)) continue;
                ((MongoSessionManager)manager).renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getNodeId(newClusterId, request));
            }
        }
    }

    protected class Purger
    implements Runnable {
        protected Purger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MongoSessionIdManager.this.purge();
            }
            finally {
                if (MongoSessionIdManager.this._scheduler != null && MongoSessionIdManager.this._scheduler.isRunning()) {
                    MongoSessionIdManager.this._purgerTask = MongoSessionIdManager.this._scheduler.schedule((Runnable)this, MongoSessionIdManager.this._purgeDelay, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    protected class Scavenger
    implements Runnable {
        protected Scavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MongoSessionIdManager.this.scavenge();
            }
            finally {
                if (MongoSessionIdManager.this._scheduler != null && MongoSessionIdManager.this._scheduler.isRunning()) {
                    MongoSessionIdManager.this._scavengerTask = MongoSessionIdManager.this._scheduler.schedule((Runnable)this, MongoSessionIdManager.this._scavengePeriod, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

