/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.IO;
import org.eclipse.jetty.toolchain.test.PathAssert;

public final class JAR {
    private JAR() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(File jarFile, File destDir) throws IOException {
        PathAssert.assertFileExists("Jar File", jarFile);
        PathAssert.assertDirExists("Destination Path", destDir);
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                File destFile = new File(destDir, FS.separators(entry.getName()));
                if (entry.isDirectory()) {
                    FS.ensureDirExists(destFile);
                    continue;
                }
                JAR.unpack(jar, entry, destFile);
            }
        }
        catch (Throwable throwable) {
            JAR.close(jar);
            throw throwable;
        }
        JAR.close(jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpack(JarFile jar, JarEntry entry, File destFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = jar.getInputStream(entry);
            out = new FileOutputStream(destFile, false);
            IO.copy(in, out);
        }
        catch (Throwable throwable) {
            IO.close(in);
            IO.close(out);
            throw throwable;
        }
        IO.close(in);
        IO.close(out);
    }

    public static void close(JarFile jar) {
        if (jar == null) {
            return;
        }
        try {
            jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(File srcDir, File jarFile) throws IOException {
        JarOutputStream jarout = null;
        FileOutputStream fileout = null;
        try {
            fileout = new FileOutputStream(jarFile);
            jarout = new JarOutputStream(fileout);
            JAR.packDir(srcDir, srcDir, jarout);
        }
        catch (Throwable throwable) {
            IO.close(jarout);
            IO.close(fileout);
            throw throwable;
        }
        IO.close(jarout);
        IO.close(fileout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packDir(File baseDir, File srcDir, JarOutputStream jarout) throws IOException {
        URI baseURI = baseDir.toURI();
        for (File file : srcDir.listFiles(IO.SafeFileFilter.INSTANCE)) {
            if (file.isDirectory()) {
                JAR.packDir(baseDir, file, jarout);
                continue;
            }
            String name = baseURI.relativize(file.toURI()).toASCIIString();
            JarEntry entry = new JarEntry(name);
            entry.setSize(file.length());
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                jarout.putNextEntry(entry);
                IO.copy(in, jarout);
            }
            finally {
                jarout.closeEntry();
                IO.close(in);
            }
        }
    }
}

