/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ant.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;

public class GitCloneTask
extends Task {
    private String uri;
    private File destination;
    private boolean bare;
    private String branch = "HEAD";

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setDest(File destination) {
        this.destination = destination;
    }

    public void setBare(boolean bare) {
        this.bare = bare;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void execute() throws BuildException {
        this.log("Cloning repository " + this.uri);
        CloneCommand clone = Git.cloneRepository();
        try {
            clone.setURI(this.uri).setDirectory(this.destination).setBranch(this.branch).setBare(this.bare);
            clone.call().getRepository().close();
        }
        catch (GitAPIException | JGitInternalException e) {
            this.log("Could not clone repository: " + String.valueOf(e), e, 0);
            throw new BuildException("Could not clone repository: " + e.getMessage(), e);
        }
    }
}

