/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.ssh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSS;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.keyboard.DefaultKeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.command.AbstractCommandSupport;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.UnknownCommand;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;

public class SshTestGitServer {
    @NonNull
    protected final String testUser;
    @NonNull
    protected final Repository repository;
    @NonNull
    protected final List<KeyPair> hostKeys = new ArrayList<KeyPair>();
    protected final SshServer server;
    @NonNull
    protected PublicKey testKey;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public SshTestGitServer(@NonNull String testUser, @NonNull Path testKey, @NonNull Repository repository, @NonNull byte[] hostKey) throws IOException, GeneralSecurityException {
        this.testUser = testUser;
        this.setTestUserPublicKey(testKey);
        this.repository = repository;
        this.server = SshServer.setUpDefaultServer();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayInputStream in = new ByteArrayInputStream(hostKey);){
                this.hostKeys.add(SecurityUtils.loadKeyPairIdentity((String)"", (InputStream)in, null));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            // empty catch block
        }
        this.server.setKeyPairProvider(() -> this.hostKeys);
        this.configureAuthentication();
        List<NamedFactory<Command>> subsystems = this.configureSubsystems();
        if (!subsystems.isEmpty()) {
            this.server.setSubsystemFactories(subsystems);
        }
        this.configureShell();
        this.server.setCommandFactory(command -> {
            if (command.startsWith("git-upload-pack")) {
                return new GitUploadPackCommand(command, this.executorService);
            }
            if (command.startsWith("git-receive-pack")) {
                return new GitReceivePackCommand(command, this.executorService);
            }
            return new UnknownCommand(command);
        });
    }

    private List<NamedFactory<UserAuth>> getAuthFactories() {
        ArrayList<NamedFactory<UserAuth>> authentications = new ArrayList<NamedFactory<UserAuth>>();
        authentications.add((NamedFactory<UserAuth>)new UserAuthGSSFactory(){

            public UserAuth create() {
                return new FakeUserAuthGSS();
            }
        });
        authentications.add((NamedFactory<UserAuth>)ServerAuthenticationManager.DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
        authentications.add((NamedFactory<UserAuth>)ServerAuthenticationManager.DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        authentications.add((NamedFactory<UserAuth>)ServerAuthenticationManager.DEFAULT_USER_AUTH_PASSWORD_FACTORY);
        return authentications;
    }

    protected void configureAuthentication() {
        this.server.setUserAuthFactories(this.getAuthFactories());
        this.server.setPasswordAuthenticator(null);
        this.server.setKeyboardInteractiveAuthenticator(null);
        this.server.setHostBasedAuthenticator(null);
        this.server.setGSSAuthenticator(new GSSAuthenticator(){

            public boolean validateInitialUser(ServerSession session, String user) {
                return false;
            }
        });
        this.server.setPublickeyAuthenticator((userName, publicKey, session) -> this.testUser.equals(userName) && KeyUtils.compareKeys((PublicKey)this.testKey, (PublicKey)publicKey));
    }

    @NonNull
    protected List<NamedFactory<Command>> configureSubsystems() {
        this.server.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(){

            protected Path computeRootDir(Session session) throws IOException {
                return SshTestGitServer.this.repository.getDirectory().getParentFile().getAbsoluteFile().toPath();
            }
        });
        return Collections.singletonList(new SftpSubsystemFactory.Builder().build());
    }

    protected void configureShell() {
        this.server.setShellFactory(null);
    }

    public void addHostKey(@NonNull Path key, boolean inFront) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = Files.newInputStream(key, new OpenOption[0]);){
            KeyPair pair = SecurityUtils.loadKeyPairIdentity((String)key.toString(), (InputStream)in, null);
            if (inFront) {
                this.hostKeys.add(0, pair);
            } else {
                this.hostKeys.add(pair);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void enablePasswordAuthentication() {
        this.server.setPasswordAuthenticator((user, pwd, session) -> this.testUser.equals(user) && this.testUser.toUpperCase(Locale.ROOT).equals(pwd));
    }

    public void enableKeyboardInteractiveAuthentication() {
        this.server.setPasswordAuthenticator((user, pwd, session) -> this.testUser.equals(user) && this.testUser.toUpperCase(Locale.ROOT).equals(pwd));
        this.server.setKeyboardInteractiveAuthenticator((KeyboardInteractiveAuthenticator)DefaultKeyboardInteractiveAuthenticator.INSTANCE);
    }

    public int start() throws IOException {
        this.server.start();
        return this.server.getPort();
    }

    public void stop() throws IOException {
        this.executorService.shutdownNow();
        this.server.stop(true);
    }

    public void setTestUserPublicKey(Path key) throws IOException, GeneralSecurityException {
        this.testKey = ((AuthorizedKeyEntry)AuthorizedKeyEntry.readAuthorizedKeys((Path)key, (OpenOption[])new OpenOption[0]).get(0)).resolvePublicKey(PublicKeyEntryResolver.IGNORING);
    }

    private static class FakeUserAuthGSS
    extends UserAuthGSS {
        private FakeUserAuthGSS() {
        }

        protected Boolean doAuth(Buffer buffer, boolean initial) throws Exception {
            if (initial) {
                ServerSession session = this.getServerSession();
                Buffer b = session.createBuffer((byte)60);
                b.putBytes(KRB5_MECH.getDER());
                session.writePacket(b);
                return null;
            }
            return Boolean.FALSE;
        }
    }

    private class GitReceivePackCommand
    extends AbstractCommandSupport {
        protected GitReceivePackCommand(String command, ExecutorService executorService) {
            super(command, executorService, false);
        }

        public void run() {
            try {
                new ReceivePack(SshTestGitServer.this.repository).receive(this.getInputStream(), this.getOutputStream(), this.getErrorStream());
                this.onExit(0);
            }
            catch (IOException e) {
                this.log.warn(MessageFormat.format("Could not run {0}", this.getCommand()), (Throwable)e);
                this.onExit(-1, e.toString());
            }
        }
    }

    private class GitUploadPackCommand
    extends AbstractCommandSupport {
        protected GitUploadPackCommand(String command, ExecutorService executorService) {
            super(command, executorService, false);
        }

        public void run() {
            UploadPack uploadPack = new UploadPack(SshTestGitServer.this.repository);
            String gitProtocol = (String)this.getEnvironment().getEnv().get("GIT_PROTOCOL");
            if (gitProtocol != null) {
                uploadPack.setExtraParameters(Collections.singleton(gitProtocol));
            }
            try {
                uploadPack.upload(this.getInputStream(), this.getOutputStream(), this.getErrorStream());
                this.onExit(0);
            }
            catch (IOException e) {
                this.log.warn(MessageFormat.format("Could not run {0}", this.getCommand()), (Throwable)e);
                this.onExit(-1, e.toString());
            }
        }
    }
}

