/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtil;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.SystemReader;

public class FS_POSIX
extends FS {
    protected static final Boolean EXECUTE_FOR_OTHERS;
    protected static final Boolean EXECUTE_FOR_GROUP;

    @Override
    public FS newInstance() {
        return new FS_POSIX();
    }

    protected static Boolean isGranted(PosixFilePermission p, String umask) {
        switch (p) {
            case OTHERS_EXECUTE: {
                char val = umask.charAt(umask.length() - 1);
                return FS_POSIX.isExecuteGranted(val);
            }
            case GROUP_EXECUTE: {
                char val = umask.charAt(umask.length() - 2);
                return FS_POSIX.isExecuteGranted(val);
            }
        }
        throw new UnsupportedOperationException("isGranted() for " + (Object)((Object)p) + " is not implemented!");
    }

    private static Boolean isExecuteGranted(char c) {
        if (c == '0' || c == '2' || c == '4' || c == '6') {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String readUmask() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset().name()));){
                p.waitFor();
                String string = lineRead.readLine();
                return string;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected File discoverGitPrefix() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (gitExe != null) {
            return gitExe.getParentFile().getParentFile();
        }
        if (SystemReader.getInstance().isMacOS()) {
            String w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            if (w == null || w.length() == 0) {
                return null;
            }
            File parentFile = new File(w).getParentFile();
            if (parentFile == null) {
                return null;
            }
            return parentFile.getParentFile();
        }
        return null;
    }

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS src) {
        super(src);
    }

    @Override
    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File f) {
        return FileUtil.canExecute(f);
    }

    @Override
    public boolean setExecute(File f, boolean canExecute) {
        if (!this.isFile(f)) {
            return false;
        }
        if (canExecute && EXECUTE_FOR_OTHERS != null) {
            try {
                Path path = f.toPath();
                Set<PosixFilePermission> pset = Files.getPosixFilePermissions(path, new LinkOption[0]);
                pset.add(PosixFilePermission.OWNER_EXECUTE);
                if (EXECUTE_FOR_GROUP.booleanValue()) {
                    pset.add(PosixFilePermission.GROUP_EXECUTE);
                }
                if (EXECUTE_FOR_OTHERS.booleanValue()) {
                    pset.add(PosixFilePermission.OTHERS_EXECUTE);
                }
                Files.setPosixFilePermissions(path, pset);
                return true;
            }
            catch (IOException e) {
                boolean debug = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
                if (debug) {
                    System.err.println(e);
                }
                return false;
            }
        }
        return f.setExecutable(canExecute);
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository, hookName, args, outRedirect, errRedirect, stdinArgs);
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public boolean isSymLink(File path) throws IOException {
        return FileUtil.isSymlink(path);
    }

    @Override
    public long lastModified(File path) throws IOException {
        return FileUtil.lastModified(path);
    }

    @Override
    public void setLastModified(File path, long time) throws IOException {
        FileUtil.setLastModified(path, time);
    }

    @Override
    public void delete(File path) throws IOException {
        FileUtil.delete(path);
    }

    @Override
    public long length(File f) throws IOException {
        return FileUtil.getLength(f);
    }

    @Override
    public boolean exists(File path) {
        return FileUtil.exists(path);
    }

    @Override
    public boolean isDirectory(File path) {
        return FileUtil.isDirectory(path);
    }

    @Override
    public boolean isFile(File path) {
        return FileUtil.isFile(path);
    }

    @Override
    public boolean isHidden(File path) throws IOException {
        return FileUtil.isHidden(path);
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
    }

    @Override
    public String readSymLink(File path) throws IOException {
        return FileUtil.readSymlink(path);
    }

    @Override
    public void createSymLink(File path, String target) throws IOException {
        FileUtil.createSymLink(path, target);
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtil.getFileAttributesPosix(this, path);
    }

    @Override
    public File normalize(File file) {
        return FileUtil.normalize(file);
    }

    @Override
    public String normalize(String name) {
        return FileUtil.normalize(name);
    }

    @Override
    public File findHook(Repository repository, String hookName) {
        File gitdir = repository.getDirectory();
        Path hookPath = gitdir.toPath().resolve("hooks").resolve(hookName);
        if (Files.isExecutable(hookPath)) {
            return hookPath.toFile();
        }
        return null;
    }

    static {
        String umask = FS_POSIX.readUmask();
        if (umask != null && umask.length() > 0 && umask.matches("\\d{3,4}")) {
            EXECUTE_FOR_OTHERS = FS_POSIX.isGranted(PosixFilePermission.OTHERS_EXECUTE, umask);
            EXECUTE_FOR_GROUP = FS_POSIX.isGranted(PosixFilePermission.GROUP_EXECUTE, umask);
        } else {
            EXECUTE_FOR_OTHERS = null;
            EXECUTE_FOR_GROUP = null;
        }
    }
}

