/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.colors;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.colors.settings.XMLColorExpression;
import org.eclipse.lemminx.extensions.colors.settings.XMLColors;
import org.eclipse.lemminx.extensions.colors.settings.XMLColorsSettings;
import org.eclipse.lsp4j.ColorInformation;
import org.junit.jupiter.api.Test;

public class XMLColorsExtensionsTest {
    @Test
    public void colorOnText() throws BadLocationException {
        XMLColorsSettings settings = XMLColorsExtensionsTest.createXMLColorsSettings();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<resources>\r\n\t<color name=\"opaque_red\">#f00</color>\r\n\t<color name=\"translucent_red\">#80ff0000</color>\r\n\t<color name=\"translucent_red\">BAD_COLOR</color>\r\n\t<no-color name=\"opaque_red\">#f00</no-color>\r\n\t<item color=\"red\" />\r\n\t<item color=\"BAD_COLOR\" />\r\n</resources>";
        XMLAssert.testColorInformationFor(xml, "file:///test/res/values/colors.xml", settings, XMLAssert.colorInfo(1.0, 0.0, 0.0, 1.0, XMLAssert.r(2, 26, 2, 30)), XMLAssert.colorInfo(0.5019607843137255, 1.0, 0.0, 0.0, XMLAssert.r(3, 31, 3, 40)));
    }

    @Test
    public void colorOnAttr() throws BadLocationException {
        XMLColorsSettings settings = XMLColorsExtensionsTest.createXMLColorsSettings();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<resources>\r\n\t<color name=\"opaque_red\">#f00</color>\r\n\t<color name=\"translucent_red\">#80ff0000</color>\r\n\t<color name=\"translucent_red\">BAD_COLOR</color>\r\n\t<item color=\"red\" />\r\n\t<item color=\"BAD_COLOR\" />\r\n</resources>";
        XMLAssert.testColorInformationFor(xml, "file:///test/colors-attr.xml", settings, XMLAssert.colorInfo(1.0, 0.0, 0.0, 1.0, XMLAssert.r(5, 14, 5, 17)));
    }

    @Test
    public void colorOnAttrWithoutValue() throws BadLocationException {
        XMLColorsSettings settings = XMLColorsExtensionsTest.createXMLColorsSettings();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<resources>\r\n\t<color name=\"opaque_red\">#f00</color>\r\n\t<color name=\"translucent_red\">#80ff0000</color>\r\n\t<item color= />\r\n\t<item color=\"red\" />\r\n\t<item color=\"BAD_COLOR\" />\r\n</resources>";
        XMLAssert.testColorInformationFor(xml, "file:///test/colors-attr.xml", settings, XMLAssert.colorInfo(1.0, 0.0, 0.0, 1.0, XMLAssert.r(5, 14, 5, 17)));
    }

    @Test
    public void colorAllPresentation() throws BadLocationException {
        XMLColorsSettings settings = XMLColorsExtensionsTest.createXMLColorsSettings();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<resources>\r\n\t<item color=\"green\" />\r\n\t<item color=\"#86c156\" />\r\n\t<item color=\"rgb(86, 143, 193)\" />\r\n\t<item color=\"rgb(20,20,20,0.5)\" />\r\n</resources>";
        XMLAssert.testColorInformationFor(xml, "file:///test/colors-attr.xml", settings, XMLAssert.colorInfo(0.0, 0.5019607843137255, 0.0, 1.0, XMLAssert.r(2, 14, 2, 19)), XMLAssert.colorInfo(0.5254901960784314, 0.7568627450980392, 0.33725490196078434, 1.0, XMLAssert.r(3, 14, 3, 21)), XMLAssert.colorInfo(0.33725490196078434, 0.5607843137254902, 0.7568627450980392, 1.0, XMLAssert.r(4, 14, 4, 31)), XMLAssert.colorInfo(0.0784313725490196, 0.0784313725490196, 0.0784313725490196, 0.5, XMLAssert.r(5, 14, 5, 31)));
    }

    @Test
    public void colorPresentation() throws BadLocationException {
        ColorInformation green = XMLAssert.colorInfo(0.0, 0.5019607843137255, 0.0, 1.0, XMLAssert.r(2, 14, 2, 19));
        XMLColorsSettings settings = XMLColorsExtensionsTest.createXMLColorsSettings();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<resources>\r\n\t<item color=\"green\" />\r\n\t<item color=\"#86c156\" />\r\n\t<item color=\"rgb(86, 143, 193)\" />\r\n\t<item color=\"rgb(20,20,20,0.5)\" />\r\n</resources>";
        XMLAssert.testColorPresentationFor(xml, "file:///test/colors-attr.xml", green.getColor(), green.getRange(), settings, XMLAssert.colorPres("rgb(0,128,0)", XMLAssert.te(2, 14, 2, 19, "rgb(0,128,0)")), XMLAssert.colorPres("#008000", XMLAssert.te(2, 14, 2, 19, "#008000")));
    }

    @Test
    public void hexWithHashInfo() throws BadLocationException {
        XMLColorsSettings settings = XMLColorsExtensionsTest.createXMLColorsSettings();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<resources>\r\n\t<color name=\"opaque_red\">f00</color>\r\n\t<color name=\"translucent_pale_red\">F110</color>\r\n</resources>";
        XMLAssert.testColorInformationFor(xml, "file:///test/res/values/colors.xml", settings, XMLAssert.colorInfo(1.0, 0.0, 0.0, 1.0, XMLAssert.r(2, 26, 2, 29)), XMLAssert.colorInfo(1.0, 0.06666666666666667, 0.06666666666666667, 0.0, XMLAssert.r(3, 36, 3, 40)));
    }

    @Test
    public void hexWithoutHashPresentation() throws BadLocationException {
        ColorInformation green = XMLAssert.colorInfo(1.0, 0.0, 1.0, 1.0, XMLAssert.r(2, 14, 2, 20));
        ColorInformation seeThroughRed = XMLAssert.colorInfo(1.0, 0.0, 0.0, 0.0, XMLAssert.r(3, 14, 3, 22));
        XMLColorsSettings settings = XMLColorsExtensionsTest.createXMLColorsSettings();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<resources>\r\n\t<item color=\"FF00FF\" />\r\n\t<item color=\"FF000000\" />\r\n</resources>";
        XMLAssert.testColorPresentationFor(xml, "file:///test/colors-attr.xml", green.getColor(), green.getRange(), settings, XMLAssert.colorPres("ff00ff", XMLAssert.te(2, 14, 2, 20, "ff00ff")));
        XMLAssert.testColorPresentationFor(xml, "file:///test/colors-attr.xml", seeThroughRed.getColor(), seeThroughRed.getRange(), settings, XMLAssert.colorPres("ff000000", XMLAssert.te(3, 14, 3, 22, "ff000000")));
    }

    private static XMLColorsSettings createXMLColorsSettings() {
        XMLColorsSettings settings = new XMLColorsSettings();
        ArrayList<XMLColors> colors = new ArrayList<XMLColors>();
        settings.setColors(colors);
        XMLColors colorsOnText = new XMLColors();
        colors.add(colorsOnText);
        colorsOnText.setPattern("**/res/values/colors.xml");
        XMLColorExpression expressionOnText = new XMLColorExpression();
        expressionOnText.setXPath("resources/color/text()");
        colorsOnText.setExpressions(Arrays.asList(expressionOnText));
        XMLColors colorsOnAttr = new XMLColors();
        colors.add(colorsOnAttr);
        colorsOnAttr.setPattern("**/colors-attr.xml");
        XMLColorExpression expressionOnAttr = new XMLColorExpression();
        expressionOnAttr.setXPath("item/@color");
        colorsOnAttr.setExpressions(Arrays.asList(expressionOnAttr));
        return settings;
    }
}

