/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.annotation.ElementType;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class BeanValidationListener
extends DescriptorEventAdapter {
    private final ValidatorFactory validatorFactory;
    private final Class[] groupPrePersit;
    private final Class[] groupPreUpdate;
    private final Class[] groupPreRemove;
    private static final Class[] groupDefault = new Class[]{Default.class};

    public BeanValidationListener(ValidatorFactory validatorFactory, Class[] groupPrePersit, Class[] groupPreUpdate, Class[] groupPreRemove) {
        this.validatorFactory = validatorFactory;
        this.groupPrePersit = groupPrePersit != null ? groupPrePersit : groupDefault;
        this.groupPreUpdate = groupPreUpdate != null ? groupPreUpdate : groupDefault;
        this.groupPreRemove = groupPreRemove;
    }

    public void prePersist(DescriptorEvent event) {
        this.validateOnCallbackEvent(event, "prePersist", this.groupPrePersit);
    }

    public void preUpdate(DescriptorEvent event) {
        Object source = event.getSource();
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)event.getSession();
        if (!unitOfWork.isObjectDeleted(source)) {
            this.validateOnCallbackEvent(event, "preUpdate", this.groupPreUpdate);
        }
    }

    public void preRemove(DescriptorEvent event) {
        if (this.groupPreRemove != null) {
            this.validateOnCallbackEvent(event, "preRemove", this.groupPreRemove);
        }
    }

    private void validateOnCallbackEvent(DescriptorEvent event, String callbackEventName, Class[] validationGroup) {
        Set constraintViolations = this.getValidator(event).validate(event.getSource(), validationGroup);
        if (constraintViolations.size() > 0) {
            throw new ConstraintViolationException("Bean Validation constraint(s) violated while executing Automatic Bean Validation on callback event:'" + callbackEventName + "'. Please refer to embedded ConstraintViolations for details.", constraintViolations);
        }
    }

    private Validator getValidator(DescriptorEvent event) {
        AutomaticLifeCycleValidationTraversableResolver traversableResolver = new AutomaticLifeCycleValidationTraversableResolver(event);
        return this.validatorFactory.usingContext().traversableResolver((TraversableResolver)traversableResolver).getValidator();
    }

    private static class AutomaticLifeCycleValidationTraversableResolver
    implements TraversableResolver {
        private ClassDescriptor descriptor;

        AutomaticLifeCycleValidationTraversableResolver(DescriptorEvent event) {
            this.descriptor = event.getClassDescriptor();
        }

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            DatabaseMapping mapping;
            boolean reachable = true;
            String attributeName = null;
            if (this.isRootObjectPath(pathToTraversableObject) && (mapping = this.getMappingForAttributeName(attributeName = traversableProperty.getName())) != null && !mapping.isAggregateMapping()) {
                if (mapping.isForeignReferenceMapping()) {
                    if (mapping.isLazy()) {
                        Object attributeValue = mapping.getAttributeAccessor().getAttributeValueFromObject(traversableObject);
                        reachable = ((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiatedOrChanged(attributeValue);
                    }
                } else {
                    FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
                    if (fetchGroupManager != null) {
                        reachable = fetchGroupManager.isAttributeFetched(traversableObject, attributeName);
                    }
                }
            }
            return reachable;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            String attributeName;
            DatabaseMapping mapping;
            boolean cascadable = true;
            if (this.isRootObjectPath(pathToTraversableObject) && (mapping = this.getMappingForAttributeName(attributeName = traversableProperty.getName())) != null && mapping.isForeignReferenceMapping()) {
                cascadable = false;
            }
            return cascadable;
        }

        private DatabaseMapping getMappingForAttributeName(String attributeName) {
            return this.descriptor.getObjectBuilder().getMappingForAttributeName(attributeName);
        }

        private boolean isRootObjectPath(Path pathToTraversableObject) {
            return ((Path.Node)pathToTraversableObject.iterator().next()).getName() == null;
        }
    }
}

