/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataColumn;

public abstract class RelationalColumnMetadata
extends MetadataColumn {
    private ForeignKeyMetadata m_foreignKey;
    private String m_referencedColumnName;

    public RelationalColumnMetadata(MetadataAnnotation relationalColumn, MetadataAccessor accessor) {
        super(relationalColumn, accessor);
        if (relationalColumn != null) {
            this.m_referencedColumnName = relationalColumn.getAttributeString("referencedColumnName");
            if (this.m_referencedColumnName == null) {
                this.m_referencedColumnName = relationalColumn.getAttributeString("referencedFieldName");
            }
            if (relationalColumn.hasAttribute("foreignKey")) {
                this.m_foreignKey = new ForeignKeyMetadata(relationalColumn.getAttributeAnnotation("foreignKey"), accessor);
            }
        }
    }

    protected RelationalColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RelationalColumnMetadata) {
            RelationalColumnMetadata relationalColumn = (RelationalColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_foreignKey, relationalColumn.getForeignKey())) {
                return false;
            }
            return this.valuesMatch(this.m_referencedColumnName, relationalColumn.getReferencedColumnName());
        }
        return false;
    }

    public ForeignKeyMetadata getForeignKey() {
        return this.m_foreignKey;
    }

    protected DatabaseField getForeignKeyField() {
        return super.getDatabaseField();
    }

    public DatabaseField getForeignKeyField(DatabaseField primaryKeyField) {
        DatabaseField fkField = this.getForeignKeyField();
        if (primaryKeyField != null) {
            fkField.setLength(primaryKeyField.getLength());
            fkField.setPrecision(primaryKeyField.getPrecision());
            fkField.setScale(primaryKeyField.getScale());
        }
        return fkField;
    }

    public String getReferencedColumnName() {
        return this.m_referencedColumnName;
    }

    public boolean hasForeignKey() {
        return this.m_foreignKey != null;
    }

    public boolean isForeignKeyFieldNotSpecified() {
        return this.getName() == null || this.getName().equals("");
    }

    public boolean isPrimaryKeyFieldNotSpecified() {
        return this.m_referencedColumnName == null || this.m_referencedColumnName.equals("");
    }

    public void setForeignKey(ForeignKeyMetadata foreignKey) {
        this.m_foreignKey = foreignKey;
    }

    public void setReferencedColumnName(String referencedColumnName) {
        this.m_referencedColumnName = referencedColumnName;
    }
}

