/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.eclipse.persistence.jpa.metadata.ProjectCache;
import org.eclipse.persistence.jpa.metadata.PropertyHelper;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.Project;

public class FileBasedProjectCache
implements ProjectCache {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project retrieveProject(Map<String, ?> properties, ClassLoader loader, SessionLog log) {
        Project project = null;
        ObjectInputStream in = null;
        String fileName = (String)this.getConfigPropertyLogDebug("eclipselink.project-cache.java-serialization.file-location", properties, log);
        if (fileName != null && fileName.length() > 0) {
            try {
                File file = new File(fileName);
                FileInputStream fis = new FileInputStream(file);
                in = new ObjectInputStream(fis);
                project = (Project)in.readObject();
            }
            catch (Exception e) {
                log.logThrowable(6, "jpa", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeProject(Project project, Map<String, ?> properties, SessionLog log) {
        String fileName = (String)this.getConfigPropertyLogDebug("eclipselink.project-cache.java-serialization.file-location", properties, log);
        if (fileName != null && fileName.length() > 0) {
            FileOutputStream fos = null;
            ObjectOutputStream out = null;
            try {
                File file = new File(fileName);
                file.createNewFile();
                fos = new FileOutputStream(file);
                out = new ObjectOutputStream(fos);
                out.writeObject(project);
            }
            catch (Exception e) {
                log.logThrowable(6, "jpa", (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                        fos = null;
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object getConfigPropertyLogDebug(String propertyName, Map<String, ?> properties, SessionLog log) {
        return PropertyHelper.getConfigPropertyLogDebug(propertyName, properties, log);
    }
}

