/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.maven.util;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

public class ArchiveUtil {
    private final ArchiverManager manager;
    public static final String DEFAULT_EXTENSION = "zip";

    public ArchiveUtil(ArchiverManager manager) {
        this.manager = manager;
    }

    public void compressDir(File srcDir, File destFile) throws MojoFailureException, MojoExecutionException {
        if (!srcDir.exists() || srcDir.isFile()) {
            throw new MojoFailureException(String.format("The source %s is not a directory", srcDir));
        }
        Archiver archiver = this.getArchiver(destFile);
        archiver.setDestFile(destFile);
        DefaultFileSet fs = new DefaultFileSet();
        fs.setDirectory(srcDir);
        try {
            archiver.addFileSet((FileSet)fs);
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Failed to create archive %s", destFile), e);
        }
    }

    public void extract(File archive, File destDir) throws MojoExecutionException, MojoFailureException {
        if (destDir.exists() && destDir.isFile()) {
            throw new MojoFailureException(String.format("The destination %s is not a directory", destDir));
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new MojoFailureException(String.format("Can't create destionation directory %s", destDir));
        }
        UnArchiver unarchiver = this.getUnArchiver(archive);
        unarchiver.setSourceFile(archive);
        unarchiver.setDestDirectory(destDir);
        try {
            unarchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException(String.format("Failed to extract %s to %s", archive, destDir));
        }
    }

    protected UnArchiver getUnArchiver(File file) throws MojoExecutionException {
        try {
            return this.manager.getUnArchiver(file);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException(String.format("Can't find unarchiver for file %s, file", file.getName()), (Exception)((Object)e));
        }
    }

    protected UnArchiver getUnArchiver() throws MojoExecutionException {
        try {
            return this.manager.getUnArchiver(DEFAULT_EXTENSION);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException(String.format("Can't find unarchiver for file %s, file", new Object[0]), (Exception)((Object)e));
        }
    }

    protected Archiver getArchiver(String hint) throws MojoExecutionException {
        try {
            return this.manager.getArchiver(hint);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException(String.format("Can't find archiver of type %s", hint), (Exception)((Object)e));
        }
    }

    protected Archiver getArchiver(File file) throws MojoExecutionException {
        try {
            return this.manager.getArchiver(file);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException(String.format("Can't find archiver for destination %s", file), (Exception)((Object)e));
        }
    }

    public Archiver getArchiver() throws MojoExecutionException {
        return this.getArchiver(DEFAULT_EXTENSION);
    }
}

