/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.maven.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.URLInputStreamFacade;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.eclipse.rcptt.maven.util.Coords;
import org.eclipse.rcptt.maven.util.PlatformUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordResolver {
    private final RepositorySystem repoSys;
    private final RepositorySystemSession repoSession;
    private final File baseDir;
    private final File targetDir;
    private final Log log;
    private final VersionScheme scheme = new GenericVersionScheme();

    public CoordResolver(File baseDir, File targetDir, RepositorySystem repoSys, RepositorySystemSession repoSession, Log log) {
        this.repoSys = repoSys;
        this.repoSession = repoSession;
        this.baseDir = baseDir;
        this.targetDir = targetDir;
        this.log = log;
    }

    public File resolve(String codename, Coords coords, List<RemoteRepository> repos) throws MojoFailureException, MojoExecutionException {
        return coords.getExplicit() == null ? this.resolveArtifact(codename, coords, repos) : this.resolveFile(coords.getExplicit());
    }

    private File resolveArtifact(String codename, Coords coords, List<RemoteRepository> repos) throws MojoExecutionException, MojoFailureException {
        if (coords.getExtension() == null) {
            coords.setExtension("zip");
            this.logDefaultValue(codename, "extension", coords.getExtension());
        }
        if (coords.getClassifier() == null) {
            coords.setClassifier(PlatformUtil.getEclipseClassifier());
            this.log.info((CharSequence)("Sys arch is " + System.getProperty("os.arch")));
            this.logDefaultValue(codename, "classifier", coords.getClassifier());
        }
        DefaultArtifact artifact = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion());
        if (coords.getVersion() == null) {
            artifact = this.resolveVersion((Artifact)artifact, repos);
            this.logDefaultValue(codename, "version", artifact.getVersion());
        }
        if (artifact.isSnapshot() && this.hasRemoteUpdates((Artifact)artifact, repos)) {
            this.log.info((CharSequence)String.format("%s is at snapshot version and has remote updates, purging local versions...", codename));
            this.purgeLocalVersion((Artifact)artifact);
        }
        this.log.info((CharSequence)String.format("Resolving artifact %s, this may take a while ...", artifact));
        ArtifactRequest request = new ArtifactRequest((Artifact)artifact, repos, null);
        try {
            ArtifactResult result = this.repoSys.resolveArtifact(this.repoSession, request);
            File resultFile = result.getArtifact().getFile();
            this.log.info((CharSequence)String.format("Artifact %s is resolved to %s", artifact, resultFile));
            return resultFile;
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(String.format("Failed to resolve artifact %s", artifact), (Exception)((Object)e));
        }
    }

    private void purgeLocalVersion(Artifact artifact) throws MojoExecutionException {
        LocalRepositoryManager localManager = this.repoSession.getLocalRepositoryManager();
        File dir = new File(localManager.getRepository().getBasedir(), localManager.getPathForLocalArtifact(artifact)).getParentFile();
        this.log.info((CharSequence)("Removing directory " + dir));
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("FAiled to clean repo", (Exception)e);
        }
    }

    private boolean hasRemoteUpdates(Artifact artifact, List<RemoteRepository> repos) {
        ArrayList<MetadataRequest> metadataRequests = new ArrayList<MetadataRequest>();
        for (RemoteRepository repo : repos) {
            DefaultMetadata metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", Metadata.Nature.SNAPSHOT);
            MetadataRequest req = new MetadataRequest((Metadata)metadata, repo, null);
            metadataRequests.add(req);
        }
        List results = this.repoSys.resolveMetadata(this.repoSession, metadataRequests);
        boolean haveUpdates = false;
        try {
            Version currentVersion = this.scheme.parseVersion(artifact.getVersion());
            for (MetadataResult result : results) {
                if (result.getException() != null || result.isMissing() || !result.isResolved() || !result.isUpdated()) continue;
                haveUpdates |= this.scheme.parseVersion(result.getMetadata().getVersion()).compareTo((Object)currentVersion) > 0;
            }
        }
        catch (InvalidVersionSpecificationException e) {
            this.log.warn((CharSequence)String.format("Cannot parse version %s", e.getVersion()));
            return false;
        }
        return haveUpdates;
    }

    private Artifact resolveVersion(Artifact artifact, List<RemoteRepository> repos) throws MojoExecutionException, MojoFailureException {
        artifact = artifact.setVersion("[0.0.1,)");
        VersionRangeRequest versionRequest = new VersionRangeRequest();
        versionRequest.setArtifact(artifact);
        versionRequest.setRepositories(repos);
        try {
            VersionRangeResult versionResult = this.repoSys.resolveVersionRange(this.repoSession, versionRequest);
            List versions = versionResult.getVersions();
            if (versions.isEmpty()) {
                throw new MojoFailureException(String.format("Failed to resolve artifact %s", artifact));
            }
            return artifact.setVersion(((Version)versions.get(versions.size() - 1)).toString());
        }
        catch (VersionRangeResolutionException e) {
            throw new MojoExecutionException(String.format("Failed to resolve versions for artifact %s", artifact), (Exception)((Object)e));
        }
    }

    private File resolveFile(String path) throws MojoFailureException, MojoExecutionException {
        if ((path = this.performSubstitution(path)).startsWith("http://") || path.startsWith("https://")) {
            return this.downloadFromHttp(path);
        }
        File result = new File(path);
        if (!result.isAbsolute()) {
            result = new File(this.baseDir, path);
        }
        if (!result.exists()) {
            throw new MojoFailureException(String.format("The explicit location %s is not valid", result));
        }
        return result;
    }

    private File downloadFromHttp(String path) throws MojoExecutionException {
        URL url;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(String.format("Malformed URL in explicit AUT location: %s", path), (Exception)e);
        }
        int lastSlashIndex = path.lastIndexOf(47);
        String fileName = lastSlashIndex == -1 ? "unknown_file" : path.substring(lastSlashIndex);
        File resultFile = new File(this.targetDir, fileName);
        try {
            this.log.info((CharSequence)String.format("Downloading artifact from %s...", path));
            FileUtils.copyStreamToFile((InputStreamFacade)new URLInputStreamFacade(url), (File)resultFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Download failed", (Exception)e);
        }
        return resultFile;
    }

    private String performSubstitution(String str) {
        if (str.indexOf("[platform]") > 0) {
            str = str.replaceAll("\\[platform\\]", PlatformUtil.getEclipseClassifier());
        }
        if (str.indexOf("[classifier]") > 0) {
            str = str.replaceAll("\\[classifier\\]", PlatformUtil.getEclipseClassifier());
        }
        return str;
    }

    private void logDefaultValue(String codename, String property, String value) {
        this.log.info((CharSequence)String.format("%s is not specified for %s, setting to %s by default", property, codename, value));
    }
}

