/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.maven.util;

import java.io.File;
import java.util.Scanner;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.eclipse.rcptt.maven.util.OS;
import org.eclipse.rcptt.maven.util.PlatformUtil;

public class JavaExec {
    private final File executable;
    private ComparableVersion version = null;

    public JavaExec(File executable) {
        this.executable = executable.getAbsoluteFile();
        if (!executable.exists()) {
            throw new IllegalArgumentException(executable + " doesn't exist");
        }
    }

    private JavaExec(File executable, ComparableVersion version) {
        this.executable = executable;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComparableVersion getVersion() {
        if (this.version == null) {
            Commandline cmd = new Commandline();
            cmd.setExecutable(this.executable.getAbsolutePath());
            cmd.createArg().setValue("-version");
            try {
                Process process = cmd.execute();
                Scanner scanner = new Scanner(process.getErrorStream());
                try {
                    scanner.useDelimiter("\"");
                    scanner.next();
                    this.version = new ComparableVersion(scanner.next());
                }
                finally {
                    scanner.close();
                }
            }
            catch (CommandLineException e) {
                throw new RuntimeException("Failed to detect Java version", e);
            }
        }
        return this.version;
    }

    static String extension() {
        return PlatformUtil.getOS() == OS.WIN ? ".exe" : "";
    }

    private static File getExecutableFromInstallation(File installation) throws MojoFailureException {
        String name = "java" + JavaExec.extension();
        File rv = new File(new File(installation, "bin"), name);
        if (!rv.exists()) {
            throw new MojoFailureException(String.format("Failed to resolve java execution location, %s does not exist", rv));
        }
        return rv;
    }

    public boolean hasPermGen() {
        return this.getVersion().compareTo(new ComparableVersion("1.8")) < 0;
    }

    public File getFile() {
        return this.executable;
    }

    private static File getDefaultInstallation() {
        String javaExec = System.getProperty("java.home");
        if (javaExec == null && (javaExec = System.getenv("JAVA_HOME")) == null) {
            throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
        }
        return new File(javaExec);
    }

    public static JavaExec getDefault() throws MojoFailureException {
        return new JavaExec(JavaExec.getExecutableFromInstallation(JavaExec.getDefaultInstallation()), new ComparableVersion(System.getProperty("java.version")));
    }
}

