/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.maven.util;

import org.eclipse.rcptt.maven.util.OS;

public class PlatformUtil {
    public static String getEclipseClassifier() {
        return String.format("%s.%s", PlatformUtil.getOS().classifier, PlatformUtil.getArch());
    }

    public static String getArch() {
        String result = System.getProperty("os.arch");
        if (result.contains("64") || PlatformUtil.getOS() == OS.MACOSX) {
            return "x86_64";
        }
        return "x86";
    }

    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WIN;
        }
        if (osName.contains("mac")) {
            return OS.MACOSX;
        }
        return OS.LINUX;
    }
}

