/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.maven.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOptions {
    public static final String EXEC_TIMEOUT = "execTimeout";
    public static final String EXEC_TIMEOUT_DEFAULT = "3600";
    public static final String TEST_EXEC_TIMEOUT = "testExecTimeout";
    public static final String TEST_EXEC_TIMEOUT_DEFAULT = "300";
    public static final Map<String, String> defaults = new HashMap<String, String>();

    public static Map<String, String> createDefaults() {
        return new HashMap<String, String>(defaults);
    }

    public static Map<String, String> fillDefaults(Map<String, String> map) {
        Map<String, String> result = TestOptions.createDefaults();
        if (map != null) {
            result.putAll(map);
        }
        return result;
    }

    public static String get(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaults.get(key);
    }

    public static int getInt(Map<String, String> map, String key) throws MojoFailureException {
        try {
            return Integer.parseInt(TestOptions.get(map, key));
        }
        catch (Exception e) {
            throw new MojoFailureException(String.format("Cannot get integer from test option %s", key));
        }
    }

    public static String toString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    static {
        defaults.put(EXEC_TIMEOUT, EXEC_TIMEOUT_DEFAULT);
        defaults.put(TEST_EXEC_TIMEOUT, TEST_EXEC_TIMEOUT_DEFAULT);
    }
}

