/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.dev.jetty;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.scout.dev.jetty.JettyConfiguration;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServer.class);
    public static final String WEB_APP_FOLDER_KEY = "scout.jetty.webapp.folder";
    public static final String WEB_APP_CONTEXT_PATH = "scout.jetty.webapp.contextpath";
    public static final String SERVER_PORT_KEY = "scout.jetty.port";
    protected volatile Server m_server = null;
    private boolean m_isInDevMode;

    public static void main(String[] args) {
        new JettyServer().start();
    }

    protected void start() {
        try {
            this.startInternal();
        }
        catch (Exception e) {
            LOG.error("Fatal: Unable to start application", (Throwable)e);
            this.shutdown();
            throw new PlatformException("Fatal: Unable to start application", new Object[]{e});
        }
    }

    protected void startInternal() throws Exception {
        String protocol;
        File webappFolder = null;
        String webappParam = System.getProperty(WEB_APP_FOLDER_KEY);
        webappFolder = webappParam == null || webappParam.isEmpty() ? new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile(), "/src/main/webapp/") : new File(webappParam);
        int port = (Integer)new JettyConfiguration.ScoutJettyPortProperty().getValue();
        String contextPath = "/";
        String contextPathConfig = System.getProperty(WEB_APP_CONTEXT_PATH);
        if (StringUtility.hasText((CharSequence)contextPathConfig)) {
            if (!contextPathConfig.startsWith("/")) {
                contextPathConfig = "/" + contextPathConfig;
            }
            contextPath = contextPathConfig;
        }
        this.m_isInDevMode = (Boolean)new PlatformConfigProperties.PlatformDevModeProperty().getValue();
        WebAppContext webApp = this.createWebApp(webappFolder, contextPath);
        Handler serverHandler = this.createServerHandler(webApp);
        this.m_server = new Server();
        this.m_server.setHandler(serverHandler);
        if (CONFIG.getPropertyValue(JettyConfiguration.ScoutJettyKeyStorePathProperty.class) != null) {
            protocol = "https";
            ServerConnector https = this.createHttpsServerConnector(port);
            this.m_server.addConnector((Connector)https);
        } else {
            protocol = "http";
            ServerConnector http = this.createHttpServerConnector(port);
            this.m_server.addConnector((Connector)http);
        }
        this.m_server.start();
        this.startConsoleInputHandler();
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Server ready. The application is available on the following addresses:\n");
            sb.append("---------------------------------------------------------------------\n");
            sb.append("  ").append(protocol).append("://localhost:").append(port).append(contextPath).append("\n");
            String hostname = InetAddress.getLocalHost().getHostName().toLowerCase();
            String ip = InetAddress.getLocalHost().getHostAddress();
            sb.append("  ").append(protocol).append("://").append(hostname).append(":").append(port).append(contextPath).append("\n");
            if (StringUtility.notEqualsIgnoreCase((String)hostname, (String)ip)) {
                sb.append("  ").append(protocol).append("://").append(ip).append(":").append(port).append(contextPath).append("\n");
            }
            sb.append("---------------------------------------------------------------------\n");
            sb.append("To shut the server down, type \"shutdown\" in the console.\n");
            LOG.info(sb.toString());
        }
    }

    public void shutdown() {
        LOG.info("Shutting down application...");
        try {
            this.shutdownInternal();
            LOG.info("Shutdown complete");
        }
        catch (Exception e) {
            LOG.error("Error while shutting down application", (Throwable)e);
        }
    }

    protected void shutdownInternal() throws Exception {
        if (this.m_server != null) {
            this.m_server.stop();
        }
    }

    protected void startConsoleInputHandler() {
        Thread t = new Thread("Console input handler"){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    var1_1 = null;
                    var2_4 = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(System.in));
                        block10: while (true) {
                            while ((command = StringUtility.trim((String)br.readLine())) != null) {
                                if (!"shutdown".equalsIgnoreCase(command)) ** GOTO lbl16
                                try {
                                    JettyServer.this.shutdown();
                                    return;
                                }
                                catch (Exception e) {
                                    JettyServer.access$0().error("Shutdown error", (Throwable)e);
                                    continue block10;
lbl16:
                                    // 1 sources

                                    if (StringUtility.hasText((CharSequence)command)) ** break;
                                    continue block10;
                                    JettyServer.access$0().warn("Unknown command: {}", (Object)command);
                                    continue;
                                    return;
                                }
                            }
                            break;
                        }
                        finally {
                            if (br != null) {
                                br.close();
                            }
                        }
                    }
                    catch (Throwable var2_5) {
                        if (var1_1 == null) {
                            var1_1 = var2_5;
                            throw var1_1;
                        }
                        if (var1_1 == var2_5) throw var1_1;
                        var1_1.addSuppressed(var2_5);
                        throw var1_1;
                    }
                }
                catch (IOException e1) {
                    JettyServer.access$0().error("Unexpected error while waiting for console command", (Throwable)e1);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected WebAppContext createWebApp(File webappDir, String contextPath) throws Exception {
        String resourceBase = webappDir.getAbsolutePath();
        P_WebAppContext webAppContext = new P_WebAppContext();
        webAppContext.setThrowUnavailableOnStartupException(true);
        webAppContext.setContextPath(contextPath);
        webAppContext.setResourceBase(resourceBase);
        webAppContext.setParentLoaderPriority(true);
        LOG.info("Starting Jetty with resourceBase={}", (Object)resourceBase);
        webAppContext.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration"});
        webAppContext.configure();
        return webAppContext;
    }

    protected Handler createServerHandler(WebAppContext webAppContext) {
        if (!"/".equals(webAppContext.getContextPath())) {
            return new P_RedirectToContextPathHandler((ContextHandler)webAppContext);
        }
        return webAppContext;
    }

    protected ServerConnector createHttpServerConnector(int port) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        ServerConnector http = new ServerConnector(this.m_server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        http.setPort(port);
        return http;
    }

    protected ServerConnector createHttpsServerConnector(int port) {
        SslContextFactory sslContextFactory = this.createSslContextFactory();
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        httpsConfig.setSendServerVersion(false);
        httpsConfig.setSendDateHeader(false);
        ServerConnector https = new ServerConnector(this.m_server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        https.setPort(port);
        return https;
    }

    protected SslContextFactory createSslContextFactory() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        String keyStorePath = this.resolveKeyStorePath((String)CONFIG.getPropertyValue(JettyConfiguration.ScoutJettyKeyStorePathProperty.class));
        String autoCertName = (String)CONFIG.getPropertyValue(JettyConfiguration.ScoutJettyAutoCreateSelfSignedCertificateProperty.class);
        String storepass = (String)CONFIG.getPropertyValue(JettyConfiguration.ScoutJettyKeyStorePasswordProperty.class);
        String keypass = (String)CONFIG.getPropertyValue(JettyConfiguration.ScoutJettyPrivateKeyPasswordProperty.class);
        String certAlias = (String)CONFIG.getPropertyValue(JettyConfiguration.ScoutJettyCertificateAliasProperty.class);
        if (autoCertName != null) {
            SecurityUtility.autoCreateSelfSignedCertificate((String)keyStorePath, (String)storepass, (String)keypass, (String)certAlias, (String)autoCertName);
        }
        LOG.info("Setup SSL certificate using alias '{}' from keystore '{}':\n{}", new Object[]{certAlias, keyStorePath, SecurityUtility.keyStoreToHumanReadableText((String)keyStorePath, (String)storepass, null)});
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword(storepass);
        sslContextFactory.setKeyManagerPassword(keypass);
        sslContextFactory.setCertAlias(certAlias);
        sslContextFactory.setEndpointIdentificationAlgorithm("https");
        sslContextFactory.setIncludeCipherSuites(new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256"});
        return sslContextFactory;
    }

    protected String resolveKeyStorePath(String path) {
        if (path.startsWith("classpath:")) {
            String subPath = path.substring(10);
            URL res = this.getClass().getResource(subPath);
            if (res == null) {
                res = this.getClass().getClassLoader().getResource(subPath);
            }
            if (res == null) {
                res = ClassLoader.getSystemClassLoader().getResource(subPath);
            }
            if (res == null) {
                throw new ProcessingException("Missing resource defined by config property: {}={}", new Object[]{((JettyConfiguration.ScoutJettyKeyStorePathProperty)((Object)BEANS.get(JettyConfiguration.ScoutJettyKeyStorePathProperty.class))).getKey(), path});
            }
            return res.toExternalForm();
        }
        return path;
    }

    protected boolean isInDevMode() {
        return this.m_isInDevMode;
    }

    protected static Set<String> getResourcePathsFromDependentJars(ClassLoader classloader, String path) {
        path = path.endsWith("/") ? path : String.valueOf(path) + "/";
        HashSet<String> resources = new HashSet<String>();
        try {
            Enumeration<URL> resourceUrls = classloader.getResources("META-INF/resources" + path);
            while (resourceUrls.hasMoreElements()) {
                URL resourceUrl = resourceUrls.nextElement();
                String absoluteResourcePath = resourceUrl.getPath();
                if ("jar".equals(resourceUrl.toURI().getScheme())) {
                    resources.addAll(JettyServer.listFilesFromJar(absoluteResourcePath, path));
                    continue;
                }
                resources.addAll(JettyServer.listFilesFromDirectory(absoluteResourcePath, path));
            }
        }
        catch (IOException | URISyntaxException e) {
            LOG.error("Failed to get resource paths", (Throwable)e);
        }
        return resources;
    }

    protected static Set<String> listFilesFromDirectory(String absoluteDirectoryPath, String relativeDirectorySearchPath) {
        File[] listFiles = new File(absoluteDirectoryPath).listFiles();
        if (listFiles == null || listFiles.length < 1) {
            return Collections.emptySet();
        }
        HashSet<String> resources = new HashSet<String>(listFiles.length);
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            resources.add(String.valueOf(relativeDirectorySearchPath) + file.getName() + (file.isDirectory() ? "/" : ""));
            ++n2;
        }
        return resources;
    }

    protected static Set<String> listFilesFromJar(String absoluteDirectoryPath, String relativeDirectorySearchPath) throws IOException {
        HashSet<String> resources = new HashSet<String>();
        String absoluteJarFilePath = absoluteDirectoryPath.substring(0, absoluteDirectoryPath.indexOf(33));
        Pattern childResourcePattern = Pattern.compile("^META-INF/resources(?<resourcePath>" + relativeDirectorySearchPath + "[^/]+)(?<slashIfDirectory>/?)$");
        Throwable throwable = null;
        Object var6_7 = null;
        try (JarFile jarFile = new JarFile(new URL(absoluteJarFilePath).getFile());){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                Matcher matcher = childResourcePattern.matcher(entry.getName());
                if (!matcher.find()) continue;
                resources.add(String.valueOf(matcher.group("resourcePath")) + matcher.group("slashIfDirectory"));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return resources;
    }

    static /* synthetic */ Logger access$0() {
        return LOG;
    }

    protected class P_RedirectToContextPathHandler
    extends HandlerWrapper {
        protected final String m_contextPath;

        public P_RedirectToContextPathHandler(ContextHandler contextHandler) {
            this.setHandler((Handler)contextHandler);
            this.m_contextPath = contextHandler.getContextPath();
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (!"GET".equals(request.getMethod())) {
                super.handle(target, baseRequest, request, response);
                return;
            }
            String requestURI = (String)ObjectUtility.nvl((Object)request.getRequestURI(), (Object)"/");
            if (!"GET".equals(request.getMethod()) || requestURI.startsWith(this.m_contextPath)) {
                super.handle(target, baseRequest, request, response);
                return;
            }
            StringBuilder redirectUri = new StringBuilder();
            redirectUri.append(request.getScheme()).append("://").append(request.getServerName());
            if ("http".equals(request.getScheme()) && request.getServerPort() != 80 || "https".equals(request.getScheme()) && request.getServerPort() != 443) {
                redirectUri.append(":").append(request.getServerPort());
            }
            redirectUri.append(this.m_contextPath);
            if (!"/".equals(requestURI)) {
                redirectUri.append(requestURI);
            }
            if (request.getQueryString() != null) {
                redirectUri.append("?").append(request.getQueryString());
            }
            response.sendRedirect(redirectUri.toString());
        }
    }

    protected class P_WebAppContext
    extends WebAppContext {
        public P_WebAppContext() {
            this._scontext = new P_Context();
        }

        public class P_Context
        extends WebAppContext.Context {
            public P_Context() {
                super((WebAppContext)P_WebAppContext.this);
            }

            public URL getResource(String path) throws MalformedURLException {
                URL url = super.getResource(path);
                if (url != null) {
                    return url;
                }
                url = this.getClassLoader().getResource("META-INF/resources" + path);
                if (url != null) {
                    return url;
                }
                if (JettyServer.this.isInDevMode()) {
                    return this.getClassLoader().getResource(path);
                }
                return null;
            }

            public Set<String> getResourcePaths(String path) {
                HashSet<String> resources = new HashSet<String>();
                resources.addAll(JettyServer.getResourcePathsFromDependentJars(this.getClassLoader(), path));
                resources.addAll(super.getResourcePaths(path));
                return resources;
            }
        }
    }
}

