/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.client.ui.form.fields.chartfield;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.AbstractChart;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.IChart;
import org.eclipse.scout.rt.chart.client.ui.form.fields.chartfield.IChartField;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;

@ClassId(value="cee88505-5685-438d-a87d-591c54efe8d7")
public abstract class AbstractChartField<T extends IChart>
extends AbstractFormField
implements IChartField<T> {
    private T m_chart;
    private IContextMenu m_contextMenu;

    public AbstractChartField() {
        super(true);
    }

    public AbstractChartField(boolean callInitializer) {
        super(callInitializer);
    }

    protected void initConfig() {
        super.initConfig();
        this.setChartInternal(this.createChart());
        List<Class<IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<IMenu> menuClazz : declaredMenus) {
            menus.addOrdered((IOrdered)((IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz)));
        }
        menus.addAllOrdered((Collection)contributedMenus);
        this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.m_contextMenu = new FormFieldContextMenu((IFormField)this, menus.getOrderedList());
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    public IContextMenu getContextMenu() {
        return this.m_contextMenu;
    }

    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    public <M extends IMenu> M getMenuByClass(Class<M> menuType) {
        return (M)MenuUtility.getMenuByClass((IContextMenuOwner)this, menuType);
    }

    protected Class<? extends IChart> getConfiguredChart() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fc = ConfigurationUtility.filterClasses((Class[])dca, IChart.class);
        if (fc.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)fc);
        }
        for (Class c : fc) {
            if (c.getDeclaringClass() == AbstractChartField.class) continue;
            return c;
        }
        return null;
    }

    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getChart())});
    }

    protected T createChart() {
        List contributedCharts = this.m_contributionHolder.getContributionsByClass(IChart.class);
        IChart result = (IChart)CollectionUtility.firstElement((List)contributedCharts);
        if (result != null) {
            return (T)result;
        }
        Class<IChart> configuredChart = this.getConfiguredChart();
        if (configuredChart != null) {
            return (T)((IChart)ConfigurationUtility.newInnerInstance((Object)this, configuredChart));
        }
        return null;
    }

    @Override
    public final T getChart() {
        return this.m_chart;
    }

    @Override
    public void setChart(T chart) {
        this.setChartInternal(chart);
    }

    protected void setChartInternal(T chart) {
        boolean changed;
        if (this.m_chart == chart) {
            return;
        }
        if (this.m_chart != null) {
            this.m_chart.setParentInternal(null);
        }
        this.m_chart = chart;
        if (this.m_chart != null) {
            this.m_chart.setParentInternal((IWidget)this);
            this.m_chart.setEnabled(this.isEnabled());
        }
        if (changed = this.propertySupport.setProperty("chart", this.m_chart)) {
            if (this.getForm() != null) {
                this.getForm().structureChanged((IFormField)this);
            }
            this.updateKeyStrokes();
        }
    }

    @ClassId(value="a6e76b7c-f42c-43b2-bcb8-55bbbc534b80")
    public class Chart
    extends AbstractChart {
    }
}

