/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.ui.html.json.basic.chart;

import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.IChart;
import org.eclipse.scout.rt.chart.shared.data.basic.chart.IChartData;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.json.JSONObject;

public class JsonChart<CHART extends IChart>
extends AbstractJsonWidget<CHART> {
    public static final String EVENT_VALUE_CLICK = "valueClick";

    public JsonChart(CHART model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    public String getObjectType() {
        return "Chart";
    }

    protected void initJsonProperties(CHART model) {
        super.initJsonProperties(model);
        this.putJsonProperty((JsonProperty)new JsonProperty<IChart>("data", model){

            protected IChartData modelValue() {
                return ((IChart)this.getModel()).getData();
            }

            public Object prepareValueForToJson(Object value) {
                return MainJsonObjectFactory.get().createJsonObject(value).toJson();
            }
        });
        this.putJsonProperty((JsonProperty)new JsonProperty<IChart>("config", model){

            protected Map<String, Object> modelValue() {
                return ((IChart)this.getModel()).getConfig() != null ? ((IChart)this.getModel()).getConfig().getProperties() : null;
            }

            public Object prepareValueForToJson(Object value) {
                return MainJsonObjectFactory.get().createJsonObject(value).toJson();
            }
        });
        this.putJsonProperty((JsonProperty)new JsonProperty<IChart>("visible", model){

            protected Object modelValue() {
                return ((IChart)this.getModel()).isVisible();
            }
        });
    }

    public void handleUiEvent(JsonEvent event) {
        if (EVENT_VALUE_CLICK.equals(event.getType())) {
            this.handleUiValueClick(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiValueClick(JsonEvent event) {
        JSONObject data = event.getData();
        BigDecimal xIndex = !data.isNull("xIndex") ? NumberUtility.getBigDecimalValue((Object)data.get("xIndex")) : null;
        BigDecimal yIndex = !data.isNull("yIndex") ? NumberUtility.getBigDecimalValue((Object)data.get("yIndex")) : null;
        Integer datasetIndex = !data.isNull("datasetIndex") ? (Integer)data.get("datasetIndex") : null;
        ((IChart)this.getModel()).getUIFacade().fireValueClickFromUI(xIndex, yIndex, datasetIndex);
    }
}

