/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.ui.html.json.basic.table.controls;

import org.eclipse.scout.rt.chart.client.ui.basic.table.controls.ChartColumnParam;
import org.eclipse.scout.rt.chart.client.ui.basic.table.controls.IChartColumnParam;
import org.eclipse.scout.rt.chart.client.ui.basic.table.controls.IChartTableControl;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.table.JsonTable;
import org.eclipse.scout.rt.ui.html.json.table.control.JsonTableControl;
import org.json.JSONObject;

public class JsonChartTableControl<CHART_TABLE_CONTROL extends IChartTableControl>
extends JsonTableControl<CHART_TABLE_CONTROL> {
    public JsonChartTableControl(CHART_TABLE_CONTROL model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    public String getObjectType() {
        return "ChartTableControl";
    }

    protected void initJsonProperties(CHART_TABLE_CONTROL model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<CHART_TABLE_CONTROL>("chartType", (IChartTableControl)model){

            protected String modelValue() {
                return ((IChartTableControl)this.getModel()).getChartType();
            }
        });
        this.putJsonProperty(new JsonProperty<CHART_TABLE_CONTROL>("chartAggregation", (IChartTableControl)model){

            protected IChartColumnParam modelValue() {
                return ((IChartTableControl)this.getModel()).getAggregation();
            }

            public Object prepareValueForToJson(Object value) {
                return JsonChartTableControl.this.createJsonObject((IChartColumnParam)value);
            }
        });
        this.putJsonProperty(new JsonProperty<CHART_TABLE_CONTROL>("chartGroup1", (IChartTableControl)model){

            protected IChartColumnParam modelValue() {
                return ((IChartTableControl)this.getModel()).getGroup1();
            }

            public Object prepareValueForToJson(Object value) {
                return JsonChartTableControl.this.createJsonObject((IChartColumnParam)value);
            }
        });
        this.putJsonProperty(new JsonProperty<CHART_TABLE_CONTROL>("chartGroup2", (IChartTableControl)model){

            protected IChartColumnParam modelValue() {
                return ((IChartTableControl)this.getModel()).getGroup2();
            }

            public Object prepareValueForToJson(Object value) {
                return JsonChartTableControl.this.createJsonObject((IChartColumnParam)value);
            }
        });
    }

    protected JSONObject createJsonObject(IChartColumnParam columnParam) {
        JSONObject json = new JSONObject();
        if (columnParam != null) {
            IColumn column = columnParam.getColumn();
            String columnId = column != null ? this.getTableAdapter().getColumnId(column) : null;
            int columnModifier = columnParam.getColumnModifier();
            json.put("id", (Object)columnId);
            json.put("modifier", columnModifier);
            return json;
        }
        return null;
    }

    protected JsonTable<?> getTableAdapter() {
        return (JsonTable)Assertions.assertInstance((Object)this.getParent(), JsonTable.class, (String)"Unexpected parent adapter: {}", (Object[])new Object[]{this.getParent()});
    }

    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("chartType".equals(propertyName)) {
            this.handleUiChartTypeChange(propertyName, data);
        } else if ("chartAggregation".equals(propertyName)) {
            this.handleUiChartAggregationChange(propertyName, data);
        } else if ("chartGroup1".equals(propertyName)) {
            this.handleUiChartGroup1Change(propertyName, data);
        } else if ("chartGroup2".equals(propertyName)) {
            this.handleUiChartGroup2Change(propertyName, data);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected void handleUiChartTypeChange(String propertyName, JSONObject data) {
        String chartType = data.getString(propertyName);
        this.addPropertyEventFilterCondition("chartType", chartType);
        ((IChartTableControl)this.getModel()).setChartType(chartType);
    }

    protected void handleUiChartAggregationChange(String propertyName, JSONObject data) {
        JSONObject chartAggregation = data.getJSONObject(propertyName);
        this.addPropertyEventFilterCondition("chartAggregation", this.createColumnParam(chartAggregation));
        ((IChartTableControl)this.getModel()).setAggregation((IChartColumnParam)this.createColumnParam(chartAggregation));
    }

    protected void handleUiChartGroup1Change(String propertyName, JSONObject data) {
        JSONObject chartGroup1 = data.optJSONObject(propertyName);
        this.addPropertyEventFilterCondition("chartGroup1", this.createColumnParam(chartGroup1));
        ((IChartTableControl)this.getModel()).setGroup1((IChartColumnParam)this.createColumnParam(chartGroup1));
    }

    protected void handleUiChartGroup2Change(String propertyName, JSONObject data) {
        JSONObject chartGroup2 = data.optJSONObject(propertyName);
        this.addPropertyEventFilterCondition("chartGroup2", this.createColumnParam(chartGroup2));
        ((IChartTableControl)this.getModel()).setGroup2((IChartColumnParam)this.createColumnParam(chartGroup2));
    }

    protected ChartColumnParam createColumnParam(JSONObject jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        String id = jsonValue.optString("id");
        int modifier = jsonValue.optInt("modifier");
        IColumn column = this.getTableAdapter().optColumn(id);
        return new ChartColumnParam(column, modifier);
    }
}

