/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.ui.html.json.basic.table.userfilter;

import java.util.List;
import org.eclipse.scout.rt.client.services.common.bookmark.internal.BookmarkUtility;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.userfilter.AbstractUserFilterState;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IColumnAwareUserFilterState;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class ChartTableUserFilterState
extends AbstractUserFilterState
implements IColumnAwareUserFilterState {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "CHART";
    private String m_text;
    private List<Object> m_filters;
    private transient IColumn<?> m_columnX;
    private transient IColumn<?> m_columnY;
    private String m_columnIdX;
    private String m_columnIdY;

    public ChartTableUserFilterState() {
        this.setType(TYPE);
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public IColumn<?> getColumnX() {
        return this.m_columnX;
    }

    public void setColumnX(IColumn<?> columnX) {
        this.m_columnX = columnX;
        this.m_columnIdX = columnX.getColumnId();
    }

    public IColumn<?> getColumnY() {
        return this.m_columnY;
    }

    public void setColumnY(IColumn<?> columnY) {
        this.m_columnY = columnY;
        this.m_columnIdY = columnY != null ? columnY.getColumnId() : null;
    }

    public List<Object> getFilters() {
        return this.m_filters;
    }

    public void setFilters(List<Object> filters) {
        this.m_filters = filters;
    }

    public String getDisplayText() {
        return this.m_text;
    }

    public boolean notifyDeserialized(Object obj) {
        ITable table = (ITable)obj;
        this.m_columnX = BookmarkUtility.resolveColumn((List)table.getColumns(), (String)this.m_columnIdX);
        if (this.m_columnIdY == null) {
            return this.m_columnX != null;
        }
        this.m_columnY = BookmarkUtility.resolveColumn((List)table.getColumns(), (String)this.m_columnIdY);
        return this.m_columnX != null && this.m_columnY != null;
    }

    public void replaceColumn(IColumn<?> col) {
        if (ObjectUtility.equals((Object)this.getColumnX().getColumnId(), (Object)col.getColumnId())) {
            this.setColumnX(col);
        }
        if (this.getColumnY() != null && ObjectUtility.equals((Object)this.getColumnY().getColumnId(), (Object)col.getColumnId())) {
            this.setColumnY(col);
        }
    }
}

