/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.ui.html.json.basic.table.userfilter;

import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.rt.chart.ui.html.json.basic.table.userfilter.ChartTableUserFilterState;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IUserFilterState;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.table.JsonTable;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.IUserFilterStateFactory;
import org.json.JSONArray;
import org.json.JSONObject;

@Order(value=5450.0)
public class UserFilterStateFactory
implements IUserFilterStateFactory {
    public IUserFilterState createUserFilterState(JsonTable<? extends ITable> table, JSONObject data) {
        String filterType = data.getString("filterType");
        if ("CHART".equals(filterType)) {
            ChartTableUserFilterState filterState = new ChartTableUserFilterState();
            filterState.setText(data.getString("text"));
            filterState.setFilters(this.createArrayValuesFromJson(data, "filters"));
            filterState.setColumnX(this.extractColumn(table, data, "columnIdX"));
            filterState.setColumnY(this.extractColumn(table, data, "columnIdY"));
            return filterState;
        }
        return null;
    }

    protected List<Object> createArrayValuesFromJson(JSONObject json, String propName) {
        JSONArray jsonArr = json.optJSONArray(propName);
        return Arrays.asList(JsonObjectUtility.unwrap((JSONArray)jsonArr));
    }

    protected IColumn extractColumn(JsonTable<? extends ITable> table, JSONObject json, String propName) {
        String columnId = json.optString(propName, null);
        if (columnId == null) {
            return null;
        }
        return table.optColumn(columnId);
    }
}

