/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.client.runner;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.reflect.ReflectionUtility;
import org.eclipse.scout.rt.testing.client.runner.RunWithClientSession;
import org.eclipse.scout.rt.testing.client.runner.statement.ClientRunContextStatement;
import org.eclipse.scout.rt.testing.client.runner.statement.RunInModelJobStatement;
import org.eclipse.scout.rt.testing.client.runner.statement.TimeoutClientRunContextStatement;
import org.eclipse.scout.rt.testing.platform.runner.PlatformTestRunner;
import org.eclipse.scout.testing.client.BlockingTestUtility;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class ClientTestRunner
extends PlatformTestRunner {
    public ClientTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Statement interceptClassLevelStatement(Statement next, Class<?> testClass) {
        RunInModelJobStatement s3 = new RunInModelJobStatement(next);
        ClientRunContextStatement s2 = new ClientRunContextStatement(s3, (RunWithClientSession)ReflectionUtility.getAnnotation(RunWithClientSession.class, (AnnotatedElement[])new AnnotatedElement[]{testClass}));
        Statement s1 = super.interceptClassLevelStatement((Statement)s2, testClass);
        return s1;
    }

    protected Statement interceptMethodLevelStatement(Statement next, Class<?> testClass, Method testMethod) {
        Statement s4 = this.hasNoTimeout(testMethod) ? new RunInModelJobStatement(next) : next;
        AddBlockingConditionTimeoutStatement s3 = new AddBlockingConditionTimeoutStatement(s4);
        ClientRunContextStatement s2 = new ClientRunContextStatement(s3, (RunWithClientSession)ReflectionUtility.getAnnotation(RunWithClientSession.class, (AnnotatedElement[])new AnnotatedElement[]{testMethod, testClass}));
        Statement s1 = super.interceptMethodLevelStatement((Statement)s2, testClass, testMethod);
        return s1;
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        long timeoutMillis = this.getTimeoutMillis(method.getMethod());
        if (timeoutMillis <= 0L) {
            return next;
        }
        return new TimeoutClientRunContextStatement(next, timeoutMillis);
    }

    protected Statement interceptBeforeStatement(Statement next, Class<?> testClass, Method testMethod) {
        Statement interceptedBeforeStatement = super.interceptBeforeStatement(next, testClass, testMethod);
        if (this.hasNoTimeout(testMethod)) {
            return interceptedBeforeStatement;
        }
        return new TimeoutClientRunContextStatement(interceptedBeforeStatement, 0L);
    }

    protected Statement interceptAfterStatement(Statement next, Class<?> testClass, Method testMethod) {
        Statement interceptedAfterStatement = super.interceptAfterStatement(next, testClass, testMethod);
        if (this.hasNoTimeout(testMethod)) {
            return interceptedAfterStatement;
        }
        return new TimeoutClientRunContextStatement(interceptedAfterStatement, 0L);
    }

    protected RunContext createJUnitRunContext() {
        return ClientRunContexts.empty();
    }

    protected static class AddBlockingConditionTimeoutStatement
    extends Statement {
        private final Statement m_statement;

        public AddBlockingConditionTimeoutStatement(Statement statement) {
            this.m_statement = statement;
        }

        public void evaluate() throws Throwable {
            BlockingTestUtility.IBlockingConditionTimeoutHandle reg = BlockingTestUtility.addBlockingConditionTimeoutListener(2L, TimeUnit.MINUTES);
            try {
                this.m_statement.evaluate();
                if (reg.getFirstException() != null) {
                    throw reg.getFirstException();
                }
            }
            finally {
                reg.dispose();
            }
        }
    }
}

