/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.client.runner.statement;

import java.security.AccessController;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.testing.client.runner.RunWithClientSession;
import org.eclipse.scout.rt.testing.platform.runner.RunWithSubject;
import org.eclipse.scout.rt.testing.platform.runner.SafeStatementInvoker;
import org.junit.runners.model.Statement;

public class ClientRunContextStatement
extends Statement {
    private final Statement m_next;
    private final RunWithClientSession m_clientSessionAnnotation;

    public ClientRunContextStatement(Statement next, RunWithClientSession clientSessionAnnotation) {
        this.m_next = (Statement)Assertions.assertNotNull((Object)next, (String)"next statement must not be null", (Object[])new Object[0]);
        this.m_clientSessionAnnotation = clientSessionAnnotation;
    }

    public void evaluate() throws Throwable {
        if (this.m_clientSessionAnnotation == null) {
            this.m_next.evaluate();
        } else {
            this.evaluateWithClientRunContext();
        }
    }

    private void evaluateWithClientRunContext() throws Throwable {
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            Assertions.fail((String)"Subject must not be null. Use the annotation '{}' to execute your test under a particular user. ", (Object[])new Object[]{RunWithSubject.class.getSimpleName()});
        }
        Class sessionClass = this.m_clientSessionAnnotation.value();
        IBean sessionBean = BEANS.getBeanManager().uniqueBean(sessionClass);
        if (sessionBean != null) {
            sessionClass = sessionBean.getBeanClazz();
        }
        IBean clientSessionBean = BEANS.getBeanManager().registerBean(new BeanMetaData(sessionClass).withOrder(-9.223372036854776E18));
        try {
            IClientSession clientSession = ((ClientSessionProvider)BEANS.get(this.m_clientSessionAnnotation.provider())).provide(ClientRunContexts.copyCurrent().withSubject(currentSubject));
            SafeStatementInvoker invoker = new SafeStatementInvoker(this.m_next);
            ClientRunContexts.copyCurrent().withSession(clientSession, true).withSubject(currentSubject).run((IRunnable)invoker);
            invoker.throwOnError();
        }
        finally {
            BEANS.getBeanManager().unregisterBean(clientSessionBean);
        }
    }
}

