/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.function.ToIntFunction;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.IJobManager;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.job.listener.IJobListener;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.eclipse.scout.rt.platform.job.listener.JobEventType;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.testing.platform.runner.JUnitExceptionHandler;
import org.eclipse.scout.testing.client.ClientSessionProviderWithCache;

public final class BlockingTestUtility {
    private BlockingTestUtility() {
    }

    public static void runBlockingAction(IRunnable runnableGettingBlocked, IRunnable runnableOnceBlocked) {
        BlockingTestUtility.runBlockingAction(runnableGettingBlocked, runnableOnceBlocked, false);
    }

    public static void runBlockingAction(IRunnable runnableGettingBlocked, IRunnable runnableOnceBlocked, boolean awaitBackgroundJobs) {
        ClientRunContext runContext = ClientRunContexts.copyCurrent();
        IBlockingCondition onceBlockedDoneCondition = Jobs.newBlockingCondition((boolean)true);
        HashSet jobsBefore = new HashSet();
        jobsBefore.addAll(((IJobManager)BEANS.get(IJobManager.class)).getFutures(cand -> {
            RunContext candContext = cand.getJobInput().getRunContext();
            return candContext instanceof ClientRunContext && ((ClientRunContext)candContext).getSession() == runContext.getSession();
        }));
        IRegistrationHandle listenerRegistration = ((IFuture)IFuture.CURRENT.get()).addListener(Jobs.newEventFilterBuilder().andMatchEventType(new JobEventType[]{JobEventType.JOB_STATE_CHANGED}).andMatchState(new JobState[]{JobState.WAITING_FOR_BLOCKING_CONDITION}).andMatchExecutionHint("ui.interaction.required").toFilter(), event -> {
            IRunnable callRunnableOnceBlocked = () -> {
                try {
                    runnableOnceBlocked.run();
                }
                finally {
                    event.getData().getBlockingCondition().setBlocking(false);
                    onceBlockedDoneCondition.setBlocking(false);
                }
            };
            JobInput jobInputForRunnableOnceBlocked = ModelJobs.newInput((ClientRunContext)runContext).withExceptionHandling((ExceptionHandler)BEANS.get(JUnitExceptionHandler.class), true).withName("JUnit: Handling blocked thread because waiting for a blocking condition", new Object[0]);
            if (awaitBackgroundJobs) {
                Jobs.schedule(() -> {
                    jobsBefore.add((IFuture)IFuture.CURRENT.get());
                    ((IJobManager)BEANS.get(IJobManager.class)).awaitFinished(f -> {
                        RunContext candContext = f.getJobInput().getRunContext();
                        return candContext instanceof ClientRunContext && ((ClientRunContext)candContext).getSession() == runContext.getSession() && !jobsBefore.contains(f);
                    }, 5L, TimeUnit.MINUTES);
                    ModelJobs.schedule((IRunnable)callRunnableOnceBlocked, (JobInput)jobInputForRunnableOnceBlocked);
                }, (JobInput)Jobs.newInput().withName("wait until background jobs finished", new Object[0]));
            } else {
                ModelJobs.schedule((IRunnable)callRunnableOnceBlocked, (JobInput)jobInputForRunnableOnceBlocked);
            }
        });
        try {
            try {
                runnableGettingBlocked.run();
            }
            catch (Exception e) {
                throw ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate((Throwable)e);
            }
        }
        finally {
            listenerRegistration.dispose();
        }
        onceBlockedDoneCondition.waitFor(120L, TimeUnit.SECONDS, new String[0]);
    }

    public static IBlockingConditionTimeoutHandle addBlockingConditionTimeoutListener(long timeout, TimeUnit unit) {
        final BlockingConditionTimeoutListener listener = new BlockingConditionTimeoutListener((ISession)IClientSession.CURRENT.get(), timeout, unit);
        final IRegistrationHandle handle = ((IJobManager)BEANS.get(IJobManager.class)).addListener(Jobs.newEventFilterBuilder().andMatchEventType(new JobEventType[]{JobEventType.JOB_STATE_CHANGED}).andMatchState(new JobState[]{JobState.WAITING_FOR_BLOCKING_CONDITION}).toFilter(), (IJobListener)listener);
        return new IBlockingConditionTimeoutHandle(){

            @Override
            public Exception getFirstException() {
                return listener.m_firstException;
            }

            public void dispose() {
                handle.dispose();
            }
        };
    }

    public static void runBlockingActionWithMessageBoxDefaultResult(IRunnable runnable, int messageBoxResult) {
        ClientRunContexts.copyCurrent().withThreadLocal(ClientSessionProviderWithCache.MESSAGE_BOX_HANDLER_STRATEGY, mBox -> messageBoxResult).run(runnable);
    }

    public static void runBlockingActionWithMessageBoxHandler(IRunnable runnable, ToIntFunction<IMessageBox> messageBoxHandler) {
        ClientRunContexts.copyCurrent().withThreadLocal(ClientSessionProviderWithCache.MESSAGE_BOX_HANDLER_STRATEGY, messageBoxHandler).run(runnable);
    }

    private static class BlockingConditionTimeoutListener
    implements IJobListener {
        private final ISession m_session;
        private final long m_timeout;
        private final TimeUnit m_unit;
        private Exception m_firstException;

        BlockingConditionTimeoutListener(ISession session, long timeout, TimeUnit unit) {
            this.m_session = session;
            this.m_timeout = timeout;
            this.m_unit = unit;
        }

        public void changed(JobEvent event) {
            IFuture future = event.getData().getFuture();
            if (future == null) {
                return;
            }
            IBlockingCondition blockingCondition = event.getData().getBlockingCondition();
            if (blockingCondition == null) {
                return;
            }
            RunContext runContext = event.getData().getFuture().getJobInput().getRunContext();
            if (!(runContext instanceof ClientRunContext)) {
                return;
            }
            ClientRunContext clientRunContext = (ClientRunContext)runContext;
            if (clientRunContext.getSession() != this.m_session) {
                return;
            }
            PlatformException callerException = new PlatformException("Testing detected a BlockingCondition that was not released after {} {}. Auto-unlocking the condition. Please check the test code and ensure that especially all forms are handled and closed correctly", new Object[]{this.m_timeout, this.m_unit});
            Jobs.schedule(() -> this.lambda$0(blockingCondition, (Exception)callerException, future), (JobInput)Jobs.newInput());
        }

        private /* synthetic */ void lambda$0(IBlockingCondition iBlockingCondition, Exception exception, IFuture iFuture) throws Exception {
            try {
                iBlockingCondition.waitFor(this.m_timeout, this.m_unit, new String[0]);
            }
            catch (TimedOutError ex) {
                if (this.m_firstException == null) {
                    this.m_firstException = exception;
                }
                iFuture.cancel(true);
                iBlockingCondition.setBlocking(false);
            }
        }
    }

    public static interface IBlockingConditionTimeoutHandle
    extends IRegistrationHandle {
        public Exception getFirstException();
    }
}

