/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import java.util.concurrent.TimeUnit;
import java.util.function.ToIntFunction;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.collection.ConcurrentExpiringMap;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.testing.client.TestingClientConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionProviderWithCache
extends ClientSessionProvider {
    public static final ThreadLocal<ToIntFunction<IMessageBox>> MESSAGE_BOX_HANDLER_STRATEGY = new ThreadLocal();
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionProviderWithCache.class);
    private final ConcurrentExpiringMap<CompositeObject, IClientSession> m_cache = this.createSessionCache((Long)CONFIG.getPropertyValue(TestingClientConfigProperties.ClientSessionCacheExpirationProperty.class));

    public <SESSION extends IClientSession> SESSION provide(ClientRunContext clientRunContext) {
        return this.provide(null, clientRunContext);
    }

    public <SESSION extends IClientSession> SESSION provide(String sessionId, ClientRunContext clientRunContext) {
        CompositeObject sessionCacheKey = this.newSessionCacheKey(sessionId, clientRunContext.getSubject());
        if (sessionCacheKey == null) {
            LOG.warn("Cannot identify cached client session because the cache key is undefined  [sessionId={}, subject={}]", (Object)sessionId, (Object)clientRunContext.getSubject());
            return (SESSION)super.provide(sessionId, clientRunContext);
        }
        IClientSession clientSession = (IClientSession)this.m_cache.get((Object)sessionCacheKey);
        if (clientSession != null) {
            return (SESSION)clientSession;
        }
        this.prepareSessionCreatingClientRunContext(clientRunContext);
        clientSession = super.provide(sessionId, clientRunContext);
        IClientSession cachedClientSession = (IClientSession)this.m_cache.putIfAbsent((Object)sessionCacheKey, (Object)clientSession);
        if (cachedClientSession != null) {
            clientSession = cachedClientSession;
        }
        return (SESSION)clientSession;
    }

    protected ConcurrentExpiringMap<CompositeObject, IClientSession> createSessionCache(long ttl) {
        return new ConcurrentExpiringMap(ttl, TimeUnit.MILLISECONDS, 1000);
    }

    protected CompositeObject newSessionCacheKey(String sessionId, Subject subject) {
        if (sessionId != null) {
            return new CompositeObject(new Object[]{((IClientSession)BEANS.get(IClientSession.class)).getClass(), sessionId});
        }
        if (subject != null) {
            return new CompositeObject(new Object[]{((IClientSession)BEANS.get(IClientSession.class)).getClass(), ((IAccessControlService)BEANS.get(IAccessControlService.class)).getUserId(subject)});
        }
        return null;
    }

    protected void prepareSessionCreatingClientRunContext(ClientRunContext clientRunContext) {
        clientRunContext.withProperty((Object)"url", (Object)"http://localhost:8082");
    }

    protected void registerSessionForNotifications(IClientSession session, String sessionId) {
        if (((IServiceTunnel)BEANS.get(IServiceTunnel.class)).isActive()) {
            super.registerSessionForNotifications(session, sessionId);
        } else {
            LOG.warn("Failed to register session for notifications.");
        }
    }

    protected void beforeStartSession(IClientSession clientSession, String sessionId) {
        ClientRunContexts.copyCurrent().getDesktop().addDesktopListener(e -> {
            switch (e.getType()) {
                case 700: {
                    this.handleMessageBox(e.getMessageBox());
                }
            }
        }, new Integer[0]);
    }

    protected void handleMessageBox(IMessageBox messageBox) {
        ToIntFunction<IMessageBox> strategy = MESSAGE_BOX_HANDLER_STRATEGY.get();
        int option = 2;
        if (strategy != null) {
            option = strategy.applyAsInt(messageBox);
        }
        messageBox.getUIFacade().setResultFromUI(option);
    }

    protected void afterStartSession(IClientSession clientSession) {
        IDesktop desktop = clientSession.getDesktop();
        if (desktop != null) {
            desktop.getUIFacade().openFromUI();
            desktop.getUIFacade().fireGuiAttached();
        }
    }
}

