/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.testenvironment;

import org.eclipse.scout.rt.client.AbstractClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.testenvironment.ui.desktop.TestEnvironmentDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.platform.IgnoreBean;
import org.eclipse.scout.rt.platform.util.StringUtility;

@IgnoreBean
public class TestEnvironmentClientSession
extends AbstractClientSession {
    private IDesktop m_testDesktop;

    public TestEnvironmentClientSession() {
        super(true);
    }

    public static TestEnvironmentClientSession get() {
        return (TestEnvironmentClientSession)ClientSessionProvider.currentSession(TestEnvironmentClientSession.class);
    }

    protected void execLoadSession() {
        TestEnvironmentDesktop d = new TestEnvironmentDesktop();
        this.setDesktop((IDesktop)d);
        this.simulateDesktopOpened((IDesktop)d);
    }

    public String getUserId() {
        String userId = super.getUserId();
        if (StringUtility.isNullOrEmpty((CharSequence)userId)) {
            userId = System.getProperty("user.name");
        }
        return userId;
    }

    public IDesktop getDesktop() {
        if (this.m_testDesktop == null) {
            return super.getDesktop();
        }
        return this.m_testDesktop;
    }

    public void replaceDesktop(IDesktop desktop) {
        this.m_testDesktop = desktop;
    }

    protected void simulateDesktopOpened(IDesktop desktop) {
        desktop.getUIFacade().openFromUI();
        desktop.getUIFacade().fireGuiAttached();
    }
}

