/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.client.runner.statement;

import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;
import org.eclipse.scout.rt.testing.platform.runner.SafeStatementInvoker;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

public class TimeoutClientRunContextStatement
extends Statement {
    protected final Statement m_next;
    private final long m_timeoutMillis;

    public TimeoutClientRunContextStatement(Statement next, long timeoutMillis) {
        this.m_timeoutMillis = timeoutMillis;
        this.m_next = (Statement)Assertions.assertNotNull((Object)next, (String)"next statement must not be null", (Object[])new Object[0]);
    }

    public void evaluate() throws Throwable {
        SafeStatementInvoker invoker = new SafeStatementInvoker(this.m_next);
        IFuture future = ModelJobs.schedule((IRunnable)invoker, (JobInput)ModelJobs.newInput((ClientRunContext)ClientRunContexts.copyCurrent()).withName("Running test with support for JUnit timeout", new Object[0]));
        try {
            if (this.m_timeoutMillis <= 0L) {
                future.awaitDone();
            } else {
                future.awaitDone(this.m_timeoutMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (ThreadInterruptedError | TimedOutError throwable) {
            future.cancel(true);
            throw new TestTimedOutException(this.m_timeoutMillis, TimeUnit.MILLISECONDS);
        }
        invoker.throwOnError();
    }
}

