/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.client.runner;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.internal.VirtualDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.reflect.ReflectionUtility;
import org.eclipse.scout.rt.testing.client.runner.RunWithClientSession;
import org.eclipse.scout.rt.testing.client.runner.statement.ClientRunContextStatement;
import org.eclipse.scout.rt.testing.client.runner.statement.RunInModelJobStatement;
import org.eclipse.scout.rt.testing.client.runner.statement.TimeoutClientRunContextStatement;
import org.eclipse.scout.rt.testing.platform.runner.PlatformTestRunner;
import org.eclipse.scout.testing.client.BlockingTestUtility;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class ClientTestRunner
extends PlatformTestRunner {
    public ClientTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Statement interceptClassLevelStatement(Statement next, Class<?> testClass) {
        CleanupDesktopStatement s4 = new CleanupDesktopStatement(next);
        RunInModelJobStatement s3 = new RunInModelJobStatement(s4);
        ClientRunContextStatement s2 = new ClientRunContextStatement(s3, (RunWithClientSession)ReflectionUtility.getAnnotation(RunWithClientSession.class, (AnnotatedElement[])new AnnotatedElement[]{testClass}));
        Statement s1 = super.interceptClassLevelStatement((Statement)s2, testClass);
        return s1;
    }

    protected Statement interceptMethodLevelStatement(Statement next, Class<?> testClass, Method testMethod) {
        CleanupDesktopStatement s5 = new CleanupDesktopStatement(next);
        Statement s4 = this.hasNoTimeout(testMethod) ? new RunInModelJobStatement(s5) : s5;
        AddBlockingConditionTimeoutStatement s3 = new AddBlockingConditionTimeoutStatement(s4);
        ClientRunContextStatement s2 = new ClientRunContextStatement(s3, (RunWithClientSession)ReflectionUtility.getAnnotation(RunWithClientSession.class, (AnnotatedElement[])new AnnotatedElement[]{testMethod, testClass}));
        Statement s1 = super.interceptMethodLevelStatement((Statement)s2, testClass, testMethod);
        return s1;
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        long timeoutMillis = this.getTimeoutMillis(method.getMethod());
        if (timeoutMillis <= 0L) {
            return next;
        }
        return new TimeoutClientRunContextStatement(next, timeoutMillis);
    }

    protected Statement interceptBeforeStatement(Statement next, Class<?> testClass, Method testMethod) {
        Statement interceptedBeforeStatement = super.interceptBeforeStatement(next, testClass, testMethod);
        if (this.hasNoTimeout(testMethod)) {
            return interceptedBeforeStatement;
        }
        return new TimeoutClientRunContextStatement(interceptedBeforeStatement, 0L);
    }

    protected Statement interceptAfterStatement(Statement next, Class<?> testClass, Method testMethod) {
        Statement interceptedAfterStatement = super.interceptAfterStatement(next, testClass, testMethod);
        if (this.hasNoTimeout(testMethod)) {
            return interceptedAfterStatement;
        }
        return new TimeoutClientRunContextStatement(interceptedAfterStatement, 0L);
    }

    protected RunContext createJUnitRunContext() {
        return ClientRunContexts.empty();
    }

    protected static class AddBlockingConditionTimeoutStatement
    extends Statement {
        private final Statement m_statement;

        public AddBlockingConditionTimeoutStatement(Statement statement) {
            this.m_statement = statement;
        }

        public void evaluate() throws Throwable {
            BlockingTestUtility.IBlockingConditionTimeoutHandle reg = BlockingTestUtility.addBlockingConditionTimeoutListener(2L, TimeUnit.MINUTES);
            try {
                this.m_statement.evaluate();
                if (reg.getFirstException() != null) {
                    throw reg.getFirstException();
                }
            }
            finally {
                reg.dispose();
            }
        }
    }

    protected static class CleanupDesktopStatement
    extends Statement {
        private final Statement m_statement;

        public CleanupDesktopStatement(Statement statement) {
            this.m_statement = statement;
        }

        public void evaluate() throws Throwable {
            Set<IForm> initialOpenForms = this.getDisplayedForms();
            try {
                this.m_statement.evaluate();
            }
            finally {
                IDesktop desktop = (IDesktop)IDesktop.CURRENT.get();
                if (desktop != null) {
                    Set<IForm> openForms = this.getDisplayedForms();
                    openForms.removeAll(initialOpenForms);
                    desktop.closeForms(openForms);
                }
            }
        }

        private Set<IForm> getDisplayedForms() {
            IDesktop desktop = (IDesktop)IDesktop.CURRENT.get();
            if (desktop == null || desktop instanceof VirtualDesktop) {
                return Collections.emptySet();
            }
            HashSet<IForm> forms = new HashSet<IForm>();
            forms.addAll(desktop.getDialogs());
            forms.addAll(desktop.getViews());
            return forms;
        }
    }
}

