/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.ClientConfigProperties;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.IMemoryPolicy;
import org.eclipse.scout.rt.client.LargeMemoryPolicy;
import org.eclipse.scout.rt.client.MediumMemoryPolicy;
import org.eclipse.scout.rt.client.SmallMemoryPolicy;
import org.eclipse.scout.rt.client.extension.ClientSessionChains;
import org.eclipse.scout.rt.client.extension.IClientSessionExtension;
import org.eclipse.scout.rt.client.session.ClientSessionStopHelper;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.internal.VirtualDesktop;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.context.PropertyMap;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.context.SharedVariableMap;
import org.eclipse.scout.rt.shared.services.common.ping.IPingService;
import org.eclipse.scout.rt.shared.services.common.security.ILogoutService;
import org.eclipse.scout.rt.shared.session.IGlobalSessionListener;
import org.eclipse.scout.rt.shared.session.ISessionListener;
import org.eclipse.scout.rt.shared.session.SessionData;
import org.eclipse.scout.rt.shared.session.SessionEvent;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientSession
extends AbstractPropertyObserver
implements IClientSession,
IExtensibleObject {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientSession.class);
    private final FastListenerList<ISessionListener> m_eventListeners;
    private final IExecutionSemaphore m_modelJobSemaphore = Jobs.newExecutionSemaphore((int)1).seal();
    private final Object m_stateLock;
    private volatile boolean m_active;
    private volatile boolean m_stopping;
    private final Semaphore m_permitToSaveBeforeClosing = new Semaphore(1);
    private final Semaphore m_permitToStop = new Semaphore(1);
    private int m_exitCode = 0;
    private String m_id;
    private IDesktop m_desktop;
    private VirtualDesktop m_virtualDesktop;
    private volatile Subject m_subject;
    private final SharedVariableMap m_sharedVariableMap;
    private IMemoryPolicy m_memoryPolicy;
    private final SessionData m_sessionData;
    private UserAgent m_userAgent;
    private final ObjectExtensions<AbstractClientSession, IClientSessionExtension<? extends AbstractClientSession>> m_objectExtensions;
    private URI m_browserUri;

    public AbstractClientSession(boolean autoInitConfig) {
        this.m_eventListeners = new FastListenerList();
        this.m_sessionData = new SessionData();
        this.m_stateLock = new Object();
        this.m_userAgent = UserAgent.get();
        this.m_subject = Subject.getSubject(AccessController.getContext());
        this.m_objectExtensions = new ObjectExtensions((Object)this, true);
        this.m_sharedVariableMap = new SharedVariableMap();
        this.setLocale(NlsLocale.get());
        if (autoInitConfig) {
            this.interceptInitConfig();
        }
    }

    public final List<? extends IClientSessionExtension<? extends AbstractClientSession>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected IClientSessionExtension<? extends AbstractClientSession> createLocalExtension() {
        return new LocalClientSessionExtension<AbstractClientSession>(this);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSingleThreadSession() {
        return false;
    }

    public String getId() {
        return this.m_id;
    }

    public String getUserId() {
        return this.getSharedContextVariable("userId", String.class);
    }

    @Override
    public final Locale getLocale() {
        return (Locale)this.propertySupport.getProperty("locale");
    }

    @Override
    public final void setLocale(Locale locale) {
        this.propertySupport.setProperty("locale", (Object)locale);
        NlsLocale.set((Locale)locale);
    }

    @Override
    public UserAgent getUserAgent() {
        if (this.m_userAgent == null) {
            this.m_userAgent = UserAgents.createDefault();
            LOG.warn("UserAgent not set; using default [default={}]", (Object)this.m_userAgent);
        }
        return this.m_userAgent;
    }

    @Override
    public void setUserAgent(UserAgent userAgent) {
        UserAgent.set((UserAgent)userAgent);
        this.m_userAgent = userAgent;
    }

    @Override
    public URI getBrowserURI() {
        return this.m_browserUri;
    }

    public boolean isActive() {
        return this.m_active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActive(boolean b) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_active = b;
            this.m_stateLock.notifyAll();
        }
    }

    public Map<String, Object> getSharedVariableMap() {
        return CollectionUtility.copyMap((Map)this.m_sharedVariableMap);
    }

    protected <T> T getSharedContextVariable(String name, Class<T> type) {
        Object o = this.m_sharedVariableMap.get((Object)name);
        return (T)TypeCastUtility.castValue((Object)o, type);
    }

    @Override
    public final Object getStateLock() {
        return this.m_stateLock;
    }

    protected void initConfig() {
        this.m_virtualDesktop = new VirtualDesktop();
        this.m_browserUri = this.resolveBrowserUri();
        this.setMemoryPolicy(this.resolveMemoryPolicy());
    }

    protected URI resolveBrowserUri() {
        String url = (String)((PropertyMap)PropertyMap.CURRENT.get()).get((Object)"url");
        if (url == null) {
            return null;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            LOG.warn("Cannot read browser url: {}", (Object)url, (Object)e);
            return null;
        }
    }

    protected IMemoryPolicy resolveMemoryPolicy() {
        switch ((String)CONFIG.getPropertyValue(ClientConfigProperties.MemoryPolicyProperty.class)) {
            case "small": {
                return new SmallMemoryPolicy();
            }
            case "medium": {
                return new MediumMemoryPolicy();
            }
        }
        return new LargeMemoryPolicy();
    }

    @Override
    public void replaceSharedVariableMapInternal(SharedVariableMap newMap) {
        this.m_sharedVariableMap.updateInternal(newMap);
    }

    protected void initializeSharedVariables() {
        ((IPingService)BEANS.get(IPingService.class)).ping("");
    }

    public void start(String sessionId) {
        Assertions.assertFalse((boolean)this.m_stopping, (String)"Session cannot be started again", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)sessionId, (String)"Session id must not be null", (Object[])new Object[0]);
        if (this.isActive()) {
            throw new IllegalStateException("session is active");
        }
        this.m_id = sessionId;
        this.interceptLoadSession();
        this.setActive(true);
        this.fireSessionChangedEvent(new SessionEvent((ISession)this, 100));
        LOG.info("Client session started [session={}, user={}]", (Object)this, (Object)this.getUserId());
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoadSession() {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execStoreSession() {
    }

    @Override
    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    @Override
    public IDesktop getDesktopElseVirtualDesktop() {
        return this.m_desktop != null ? this.m_desktop : this.m_virtualDesktop;
    }

    @Override
    public void setDesktop(IDesktop desktop) {
        if (desktop == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (this.m_desktop != null) {
            throw new IllegalStateException("desktop is active");
        }
        this.m_desktop = desktop;
        if (this.m_virtualDesktop != null) {
            this.m_desktop.desktopListeners().addAll(this.m_virtualDesktop.desktopListeners());
            this.m_virtualDesktop.getPropertyChangeListenerMap().forEach((propName, listeners) -> listeners.forEach(listener -> {
                if (propName == null) {
                    this.m_desktop.addPropertyChangeListener((PropertyChangeListener)listener);
                } else {
                    this.m_desktop.addPropertyChangeListener((String)propName, (PropertyChangeListener)listener);
                }
            }));
            this.m_desktop.dataChangeListeners().addAll(this.m_virtualDesktop.dataChangeListeners());
            this.m_desktop.dataChangeDesktopInForegroundListeners().addAll(this.m_virtualDesktop.dataChangeDesktopInForegroundListeners());
            this.m_virtualDesktop = null;
        }
        this.m_desktop.init();
    }

    @Override
    public void stop() {
        this.stop(this.m_exitCode);
    }

    @Override
    public void stop(int exitCode) {
        LOG.info("Enter stop({}) of clientSession {}", (Object)exitCode, (Object)this);
        try {
            if (this.m_desktop != null && this.m_permitToSaveBeforeClosing.tryAcquire()) {
                LOG.info("Call desktop.doBeforeClosingInternal of clientSession {}", (Object)this);
                if (!this.m_desktop.doBeforeClosingInternal()) {
                    this.m_permitToSaveBeforeClosing.release();
                    LOG.info("Not stopping clientSession, user veto on {}", (Object)this);
                    return;
                }
            }
        }
        catch (RuntimeException | PlatformError e) {
            LOG.error("Failed to decently handle doBeforeClosingInternal", e);
        }
        ClientSessionStopHelper helper = (ClientSessionStopHelper)BEANS.get(ClientSessionStopHelper.class);
        IFuture<?> termLoop = helper.scheduleJobTerminationLoop(this);
        try {
            block19: {
                this.m_stopping = true;
                if (!this.m_permitToStop.tryAcquire()) {
                    LOG.warn("Not stopping clientSession, could not acquire stop lock of {}", (Object)this);
                    return;
                }
                LOG.info("Begin stop of clientSession {}, point of no return", (Object)this);
                this.m_exitCode = exitCode;
                try {
                    this.fireSessionChangedEvent(new SessionEvent((ISession)this, 105));
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.error("Failed to send STOPPING event.", e);
                }
                try {
                    this.interceptStoreSession();
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.error("Failed to store the client session.", e);
                }
                if (this.m_desktop != null) {
                    try {
                        try {
                            this.m_desktop.dispose();
                        }
                        catch (RuntimeException | PlatformError e) {
                            LOG.error("Failed to close the desktop.", e);
                            this.m_desktop = null;
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        this.m_desktop = null;
                        throw throwable;
                    }
                    this.m_desktop = null;
                }
            }
            this.inactivateSession();
        }
        finally {
            termLoop.cancel(true);
        }
    }

    @Deprecated
    protected void cancelRunningJobs() {
    }

    protected void inactivateSession() {
        try {
            ILogoutService logoutService = (ILogoutService)BEANS.opt(ILogoutService.class);
            if (logoutService != null) {
                logoutService.logout();
            }
        }
        finally {
            this.setActive(false);
            this.fireSessionChangedEvent(new SessionEvent((ISession)this, 110));
            LOG.info("Client session stopped [session={}, user={}]", (Object)this, (Object)this.getUserId());
        }
    }

    public boolean isStopping() {
        return this.m_stopping;
    }

    @Override
    public int getExitCode() {
        return this.m_exitCode;
    }

    @Override
    public IMemoryPolicy getMemoryPolicy() {
        return this.m_memoryPolicy;
    }

    @Override
    public void setMemoryPolicy(IMemoryPolicy memoryPolicy) {
        if (this.m_memoryPolicy != null) {
            this.m_memoryPolicy.removeNotify();
        }
        this.m_memoryPolicy = memoryPolicy;
        if (this.m_memoryPolicy != null) {
            this.m_memoryPolicy.addNotify();
        }
    }

    @Override
    public Subject getSubject() {
        return this.m_subject;
    }

    @Override
    public void setSubject(Subject subject) {
        this.m_subject = subject;
    }

    public void setData(String key, Object value) {
        this.m_sessionData.set(key, value);
    }

    public Object computeDataIfAbsent(String key, Callable<?> producer) {
        return this.m_sessionData.computeIfAbsent(key, producer);
    }

    public Object getData(String key) {
        return this.m_sessionData.get(key);
    }

    protected final void interceptStoreSession() {
        List<? extends IClientSessionExtension<? extends AbstractClientSession>> extensions = this.getAllExtensions();
        ClientSessionChains.ClientSessionStoreSessionChain chain = new ClientSessionChains.ClientSessionStoreSessionChain(extensions);
        chain.execStoreSession();
    }

    protected final void interceptLoadSession() {
        List<? extends IClientSessionExtension<? extends AbstractClientSession>> extensions = this.getAllExtensions();
        ClientSessionChains.ClientSessionLoadSessionChain chain = new ClientSessionChains.ClientSessionLoadSessionChain(extensions);
        chain.execLoadSession();
    }

    public IFastListenerList<ISessionListener> sessionListeners() {
        return this.m_eventListeners;
    }

    @Override
    public IExecutionSemaphore getModelJobSemaphore() {
        return this.m_modelJobSemaphore;
    }

    protected void fireSessionChangedEvent(SessionEvent event) {
        this.sessionListeners().list().forEach(listener -> this.handleSessionEvent((ISessionListener)listener, event));
        BEANS.all(IGlobalSessionListener.class).forEach(listener -> this.handleSessionEvent((ISessionListener)listener, event));
    }

    protected void handleSessionEvent(ISessionListener listener, SessionEvent event) {
        try {
            listener.sessionChanged(event);
        }
        catch (RuntimeException e) {
            if (event.getType() != 110 && event.getType() != 105) {
                throw e;
            }
            LOG.warn("Error in session listener {}.", listener.getClass(), (Object)e);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[id = " + this.getId() + "]";
    }

    protected static class LocalClientSessionExtension<OWNER extends AbstractClientSession>
    extends AbstractExtension<OWNER>
    implements IClientSessionExtension<OWNER> {
        public LocalClientSessionExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execStoreSession(ClientSessionChains.ClientSessionStoreSessionChain chain) {
            ((AbstractClientSession)this.getOwner()).execStoreSession();
        }

        @Override
        public void execLoadSession(ClientSessionChains.ClientSessionLoadSessionChain chain) {
            ((AbstractClientSession)this.getOwner()).execLoadSession();
        }
    }
}

