/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.rt.client.AbstractMemoryPolicy;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.TableUserFilterManager;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.util.collection.ConcurrentExpiringMap;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediumMemoryPolicy
extends AbstractMemoryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MediumMemoryPolicy.class);
    private boolean m_release = false;
    private final ConcurrentExpiringMap<String, AbstractMemoryPolicy.SearchFormState> m_searchFormCache = new ConcurrentExpiringMap(0L, TimeUnit.MILLISECONDS, 5);
    private final ConcurrentExpiringMap<String, byte[]> m_tableUserFilterState = new ConcurrentExpiringMap(0L, TimeUnit.MILLISECONDS, 5);

    @Override
    protected void loadSearchFormState(IForm f, String pageFormIdentifier) {
        AbstractMemoryPolicy.SearchFormState state = (AbstractMemoryPolicy.SearchFormState)this.m_searchFormCache.get((Object)pageFormIdentifier);
        if (state != null) {
            if (state.m_formContentXml != null) {
                f.loadFromXmlString(state.m_formContentXml);
            }
            if (state.m_searchFilter != null) {
                f.setSearchFilter(state.m_searchFilter);
            }
        }
    }

    @Override
    protected void storeSearchFormState(IForm f, String pageFormIdentifier) {
        if (f.isEmpty()) {
            this.m_searchFormCache.remove((Object)pageFormIdentifier);
        } else {
            String xml = f.storeToXmlString();
            SearchFilter filter = f.getSearchFilter();
            this.m_searchFormCache.put((Object)pageFormIdentifier, (Object)new AbstractMemoryPolicy.SearchFormState(xml, filter));
        }
    }

    @Override
    protected void storeUserFilterState(ITable table, String pageTableIdentifier) {
        TableUserFilterManager filterManager = table.getUserFilterManager();
        if (filterManager == null || filterManager.isEmpty()) {
            this.m_tableUserFilterState.remove((Object)pageTableIdentifier);
            return;
        }
        this.m_tableUserFilterState.put((Object)pageTableIdentifier, (Object)filterManager.getSerializedData());
    }

    @Override
    protected void loadUserFilterState(ITable table, String pageTableIdentifier) {
        TableUserFilterManager filterManager = table.getUserFilterManager();
        if (filterManager == null) {
            return;
        }
        byte[] state = (byte[])this.m_tableUserFilterState.get((Object)pageTableIdentifier);
        if (state != null) {
            filterManager.setSerializedData(state);
        }
    }

    @Override
    public void afterOutlineSelectionChanged(IDesktop desktop) {
        try {
            long memMax;
            long memTotal;
            long memUsed;
            final AtomicLong nodeCount = new AtomicLong();
            if (desktop.getOutline() != null && desktop.getOutline().getSelectedNode() != null) {
                final HashSet preservationSet = new HashSet();
                IPage<?> p = (IPage<?>)desktop.getOutline().getSelectedNode();
                while (p != null) {
                    preservationSet.add(p);
                    p = p.getParentPage();
                }
                DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                    public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                        IPage page = (IPage)node;
                        if (!preservationSet.contains(page) && page.getParentPage() != null && page.isChildrenLoaded()) {
                            nodeCount.getAndAdd(page.getChildNodeCount());
                        }
                        return TreeVisitResult.CONTINUE;
                    }
                };
                for (IOutline outline : desktop.getAvailableOutlines()) {
                    outline.visitNode(outline.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
                }
            }
            if ((memUsed = (memTotal = Runtime.getRuntime().totalMemory()) - Runtime.getRuntime().freeMemory()) > (memMax = Runtime.getRuntime().maxMemory()) * 80L / 100L || nodeCount.get() > 10000L) {
                this.m_release = true;
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected Exception", (Throwable)e);
        }
    }

    @Override
    public void beforeTablePageLoadData(IPageWithTable<?> page) {
        if (this.m_release) {
            IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
            for (IOutline o : desktop.getAvailableOutlines()) {
                if (o == desktop.getOutline()) continue;
                o.selectNode(null);
            }
            desktop.releaseUnusedPages();
            this.m_release = false;
        }
        if (page.getTable() != null && ((ITable)page.getTable()).getRowCount() > 1000) {
            ((ITable)page.getTable()).discardAllRows();
        }
    }

    @Override
    public String toString() {
        return "Medium";
    }
}

