/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.lang.reflect.Proxy;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.reflect.ReflectionUtility;

@ApplicationScoped
public class ModelContextProxy {
    public <OBJECT> OBJECT newProxy(OBJECT object, ModelContext modelContext) {
        return (OBJECT)Proxy.newProxyInstance(object.getClass().getClassLoader(), ReflectionUtility.getInterfaces(object.getClass()), (proxy, method, args) -> ClientRunContexts.copyCurrent().withDesktop(modelContext.getDesktop()).withOutline(modelContext.getOutline(), false).withForm(modelContext.getForm()).call(() -> method.invoke(object, args), DefaultExceptionTranslator.class));
    }

    public static final class ModelContext {
        private IDesktop m_desktop;
        private IOutline m_outline;
        private IForm m_form;

        private ModelContext() {
        }

        public static ModelContext copyCurrent() {
            return new ModelContext().withDesktop(IDesktop.CURRENT.get()).withOutline(IOutline.CURRENT.get()).withForm(IForm.CURRENT.get());
        }

        public IDesktop getDesktop() {
            return this.m_desktop;
        }

        public ModelContext withDesktop(IDesktop desktop) {
            this.m_desktop = desktop;
            return this;
        }

        public IOutline getOutline() {
            return this.m_outline;
        }

        public ModelContext withOutline(IOutline outline) {
            this.m_outline = outline;
            return this;
        }

        public IForm getForm() {
            return this.m_form;
        }

        public ModelContext withForm(IForm form) {
            this.m_form = form;
            return this;
        }
    }
}

