/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.rt.client.cache.ClientNotificationClientCacheWrapper;
import org.eclipse.scout.rt.client.cache.RemoteCacheValueResolver;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.cache.BasicCache;
import org.eclipse.scout.rt.platform.cache.CacheBuilder;
import org.eclipse.scout.rt.platform.cache.ICache;
import org.eclipse.scout.rt.shared.cache.IRemoteCacheService;

@Order(value=5050.0)
public class ClientCacheBuilder<K, V>
extends CacheBuilder<K, V> {
    protected ICache<K, V> createBasicCache(Map<K, V> cacheMap) {
        RemoteCacheValueResolver valueResolver = this.getValueResolver();
        if (this.isSharedAndRemoteAvailable() && this.isRemoteValueResolverEnabled()) {
            valueResolver = new RemoteCacheValueResolver(this.getCacheId());
        }
        return new BasicCache(this.getCacheId(), valueResolver, cacheMap, this.isAtomicInsertion());
    }

    protected ICache<K, V> addBeforeCustomWrappers(ICache<K, V> cache) {
        cache = super.addBeforeCustomWrappers(cache);
        if (this.isSharedAndRemoteAvailable()) {
            cache = new ClientNotificationClientCacheWrapper(cache);
        }
        return cache;
    }

    protected Map<K, V> createCacheMap() {
        if (this.isTransactional()) {
            return new ConcurrentHashMap();
        }
        return super.createCacheMap();
    }

    protected boolean isSharedAndRemoteAvailable() {
        return this.isShared() && BEANS.opt(IRemoteCacheService.class) != null;
    }
}

