/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.clientnotification;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.clientnotification.IClientSessionRegistry;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.services.common.ping.IPingService;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.shared.session.IGlobalSessionListener;
import org.eclipse.scout.rt.shared.session.SessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionRegistry
implements IClientSessionRegistry,
IGlobalSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionRegistry.class);
    private final Object m_cacheLock = new Object();
    private final Map<String, WeakReference<IClientSession>> m_sessionIdToSession = new HashMap<String, WeakReference<IClientSession>>();
    private final Map<String, List<WeakReference<IClientSession>>> m_userToSessions = new HashMap<String, List<WeakReference<IClientSession>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(IClientSession session, String sessionId) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            this.m_sessionIdToSession.put(sessionId, new WeakReference<IClientSession>(session));
        }
        if (((IServiceTunnel)BEANS.get(IServiceTunnel.class)).isActive() && session.isActive()) {
            this.sessionStarted(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionStopped(IClientSession session) {
        this.checkSession(session);
        String sessionId = session.getId();
        String userId = session.getUserId();
        LOG.debug("Unregister client session [sessionid={}, userId={}].", (Object)sessionId, (Object)userId);
        Object object = this.m_cacheLock;
        synchronized (object) {
            this.m_sessionIdToSession.remove(session.getId());
            List<WeakReference<IClientSession>> userSessions = this.m_userToSessions.get(userId);
            if (userSessions != null) {
                Iterator<WeakReference<IClientSession>> it = userSessions.iterator();
                while (it.hasNext()) {
                    WeakReference<IClientSession> ref = it.next();
                    IClientSession clientSession = (IClientSession)ref.get();
                    if (clientSession != null && !ObjectUtility.equals((Object)clientSession.getId(), (Object)session.getId())) continue;
                    it.remove();
                }
                if (userSessions.isEmpty()) {
                    this.m_userToSessions.remove(userId);
                }
            }
        }
    }

    public void sessionStarted(IClientSession session) {
        this.ensureUserIdAvailable(session);
        this.checkSession(session);
        LOG.debug("Register client session [sessionid={}, userId={}].", (Object)session.getId(), (Object)session.getUserId());
        this.registerUser(session);
    }

    private void checkSession(IClientSession session) {
        Assertions.assertNotNull((Object)session.getId(), (String)"No sessionId available", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)session.getUserId(), (String)"No userId available", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerUser(IClientSession session) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            List<WeakReference<IClientSession>> sessionRefs = this.m_userToSessions.get(session.getUserId());
            if (sessionRefs != null) {
                boolean toBeAdded = true;
                Iterator<WeakReference<IClientSession>> sessionRefIt = sessionRefs.iterator();
                while (sessionRefIt.hasNext()) {
                    WeakReference<IClientSession> sessionRef = sessionRefIt.next();
                    if (sessionRef.get() == null) {
                        sessionRefIt.remove();
                        continue;
                    }
                    if (sessionRef.get() != session) continue;
                    toBeAdded = false;
                }
                if (toBeAdded) {
                    sessionRefs.add(new WeakReference<IClientSession>(session));
                }
            } else {
                sessionRefs = new LinkedList<WeakReference<IClientSession>>();
                sessionRefs.add(new WeakReference<IClientSession>(session));
                this.m_userToSessions.put(session.getUserId(), sessionRefs);
            }
        }
    }

    protected void ensureUserIdAvailable(IClientSession session) {
        ((IPingService)BEANS.get(IPingService.class)).ping("ensure shared context is loaded...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClientSession getClientSession(String sessionId) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            WeakReference<IClientSession> sessionRef = this.m_sessionIdToSession.get(sessionId);
            if (sessionRef != null && sessionRef.get() != null) {
                return (IClientSession)sessionRef.get();
            }
            this.m_sessionIdToSession.remove(sessionId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IClientSession> getClientSessionsForUser(String userId) {
        LinkedList<IClientSession> result = new LinkedList<IClientSession>();
        Object object = this.m_cacheLock;
        synchronized (object) {
            List<WeakReference<IClientSession>> userSessions = this.m_userToSessions.get(userId);
            if (userSessions == null) {
                if (this.isCurrentSession(userId)) {
                    return CollectionUtility.arrayList((Object)((IClientSession)IClientSession.CURRENT.get()));
                }
                LOG.debug("No session found for user {}", (Object)userId);
                return CollectionUtility.emptyArrayList();
            }
            Iterator<WeakReference<IClientSession>> refIt = userSessions.iterator();
            while (refIt.hasNext()) {
                WeakReference<IClientSession> sessionRef = refIt.next();
                if (sessionRef.get() != null) {
                    result.add((IClientSession)sessionRef.get());
                    continue;
                }
                refIt.remove();
            }
        }
        return result;
    }

    protected boolean isCurrentSession(String userId) {
        IClientSession currentSession = (IClientSession)IClientSession.CURRENT.get();
        return currentSession != null && ObjectUtility.equals((Object)currentSession.getUserId(), (Object)userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IClientSession> getAllClientSessions() {
        LinkedList<IClientSession> result = new LinkedList<IClientSession>();
        Object object = this.m_cacheLock;
        synchronized (object) {
            Iterator<Map.Entry<String, WeakReference<IClientSession>>> iterator = this.m_sessionIdToSession.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, WeakReference<IClientSession>> e = iterator.next();
                if (e.getValue().get() != null) {
                    result.add((IClientSession)e.getValue().get());
                    continue;
                }
                iterator.remove();
            }
        }
        return result;
    }

    public void sessionChanged(SessionEvent event) {
        if (!((IServiceTunnel)BEANS.get(IServiceTunnel.class)).isActive()) {
            return;
        }
        ISession source = event.getSource();
        if (source instanceof IClientSession) {
            switch (event.getType()) {
                case 100: {
                    this.sessionStarted((IClientSession)source);
                    break;
                }
                case 110: {
                    this.sessionStopped((IClientSession)source);
                    break;
                }
            }
        }
    }
}

