/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.job;

import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.util.Assertions;

@ApplicationScoped
public class ModelJobValidator {
    public void validateRunContext(RunContext runContext) {
        Assertions.assertTrue((boolean)(runContext instanceof ClientRunContext), (String)"A model job requires a ClientRunContext", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)((ClientRunContext)runContext).getSession(), (String)"A model job requires a ClientSession in the ClientRunContext", (Object[])new Object[0]);
        Assertions.assertEquals((Object)1, (Object)((ClientRunContext)runContext).getSession().getModelJobSemaphore().getPermits(), (String)"A model job requires a semaphore with permit size 1 for mutual exclusion", (Object[])new Object[0]);
    }

    public void validateJobInput(JobInput input) {
        Assertions.assertNotNull((Object)input, (String)"A model job requires a job input", (Object[])new Object[0]);
        this.validateRunContext(input.getRunContext());
        Assertions.assertSame((Object)((ClientRunContext)input.getRunContext()).getSession().getModelJobSemaphore(), (Object)input.getExecutionSemaphore(), (String)"A model job requires the session's model job semaphore", (Object[])new Object[0]);
    }
}

