/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.job;

import java.util.concurrent.Callable;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobValidator;
import org.eclipse.scout.rt.client.job.filter.event.ModelJobEventFilter;
import org.eclipse.scout.rt.client.job.filter.future.ModelJobFutureFilter;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.IJobManager;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.job.filter.event.JobEventFilterBuilder;
import org.eclipse.scout.rt.platform.job.filter.future.FutureFilterBuilder;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;

public final class ModelJobs {
    public static final String EXECUTION_HINT_UI_INTERACTION_REQUIRED = "ui.interaction.required";
    public static final String EXECUTION_HINT_NOT_CANCELLABLE_BY_USER = "not.cancellable.by.user";
    private static final IRunnable NULL_RUNNABLE = () -> {};

    private ModelJobs() {
    }

    public static IFuture<Void> schedule(IRunnable runnable, JobInput input) {
        ((ModelJobValidator)BEANS.get(ModelJobValidator.class)).validateJobInput(input);
        return ((IJobManager)BEANS.get(IJobManager.class)).schedule(runnable, input);
    }

    public static <RESULT> IFuture<RESULT> schedule(Callable<RESULT> callable, JobInput input) {
        ((ModelJobValidator)BEANS.get(ModelJobValidator.class)).validateJobInput(input);
        return ((IJobManager)BEANS.get(IJobManager.class)).schedule(callable, input);
    }

    public static JobInput newInput(ClientRunContext clientRunContext) {
        ((ModelJobValidator)BEANS.get(ModelJobValidator.class)).validateRunContext(clientRunContext);
        return ((JobInput)BEANS.get(JobInput.class)).withThreadName("scout-model-thread").withRunContext((RunContext)clientRunContext).withExecutionSemaphore(clientRunContext.getSession().getModelJobSemaphore());
    }

    public static FutureFilterBuilder newFutureFilterBuilder() {
        return ((FutureFilterBuilder)BEANS.get(FutureFilterBuilder.class)).andMatch(ModelJobFutureFilter.INSTANCE);
    }

    public static JobEventFilterBuilder newEventFilterBuilder() {
        return ((JobEventFilterBuilder)BEANS.get(JobEventFilterBuilder.class)).andMatch(ModelJobEventFilter.INSTANCE);
    }

    public static boolean isModelThread() {
        return ModelJobs.isModelThread(ClientSessionProvider.currentSession());
    }

    public static boolean isModelThread(IClientSession clientSession) {
        IFuture currentFuture = (IFuture)IFuture.CURRENT.get();
        if (!ModelJobs.isModelJob(currentFuture)) {
            return false;
        }
        IExecutionSemaphore semaphore = currentFuture.getExecutionSemaphore();
        return semaphore != null && semaphore.isPermitOwner(currentFuture);
    }

    public static void assertModelThread() {
        if (!ModelJobs.isModelThread()) {
            throw new WrongThreadException("Only the model thread is allowed to update the UI model.", new Object[0]);
        }
    }

    public static boolean isModelJob(IFuture<?> future) {
        if (future == null) {
            return false;
        }
        if (future.getJobInput().getExecutionSemaphore() == null) {
            return false;
        }
        if (!(future.getJobInput().getRunContext() instanceof ClientRunContext)) {
            return false;
        }
        IClientSession clientSession = ((ClientRunContext)future.getJobInput().getRunContext()).getSession();
        if (clientSession == null) {
            return false;
        }
        return future.getJobInput().getExecutionSemaphore() == clientSession.getModelJobSemaphore();
    }

    public static void yield() {
        Assertions.assertTrue((boolean)ModelJobs.isModelThread(), (String)"'Yield' must be invoked from model thread", (Object[])new Object[0]);
        IBlockingCondition idleCondition = Jobs.newBlockingCondition((boolean)true);
        ModelJobs.schedule(NULL_RUNNABLE, ModelJobs.newInput(ClientRunContexts.copyCurrent()).withName("Technical job to yield model thread", new Object[0])).whenDone(event -> idleCondition.setBlocking(false), (RunContext)ClientRunContexts.copyCurrent());
        idleCondition.waitFor(new String[0]);
    }

    public static class WrongThreadException
    extends Assertions.AssertionException {
        private static final long serialVersionUID = 1L;

        public WrongThreadException(String msg, Object ... msgArgs) {
            super(msg, msgArgs);
        }
    }
}

