/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.exceptionhandler;

import java.util.concurrent.Semaphore;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.ErrorPopup;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.IProcessingStatus;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Replace
public class ClientExceptionHandler
extends ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientExceptionHandler.class);
    private static final String LOOP_DETECTION_KEY = "ClientExceptionHandler#loopDetectionSemaphore";

    protected void handlePlatformException(PlatformException e) {
        super.handlePlatformException(e);
        this.showExceptionInternal((Throwable)e);
    }

    protected void handleThrowable(Throwable t) {
        super.handleThrowable(t);
        this.showExceptionInternal(t);
    }

    protected void showExceptionInternal(Throwable t) {
        IClientSession session = ClientSessionProvider.currentSession();
        if (session == null) {
            return;
        }
        if (session.isStopping() || session.getDesktop() == null || !session.getDesktop().isOpened()) {
            return;
        }
        Semaphore loopDetectionSemaphore = this.getLoopDetectionSemaphore();
        if (loopDetectionSemaphore.tryAcquire()) {
            try {
                if (ModelJobs.isModelThread()) {
                    this.showException(t);
                }
                try {
                    ModelJobs.schedule(() -> this.showException(t), ModelJobs.newInput(ClientRunContexts.copyCurrent()).withExceptionHandling(null, true).withName("Visualizing PlatformException", new Object[0])).awaitDone();
                }
                catch (ThreadInterruptedError threadInterruptedError) {}
            }
            finally {
                loopDetectionSemaphore.release();
            }
        } else {
            Exception e = new Exception("Stacktrace and suppressed exception");
            e.addSuppressed(t);
            LOG.warn("Loop detection in {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)e);
            if (ModelJobs.isModelThread()) {
                IMessageBox msgBox = MessageBoxes.createOk().withSeverity(0x1000000).withHeader(TEXTS.get((String)"Error"));
                if (t instanceof VetoException) {
                    IProcessingStatus status = ((ProcessingException)t).getStatus();
                    msgBox.withHeader(status.getTitle()).withBody(status.getBody());
                }
                msgBox.show();
            }
        }
    }

    protected void showException(Throwable t) {
        ((ErrorPopup)BEANS.get(ErrorPopup.class)).showMessageBox(t);
    }

    protected Semaphore getLoopDetectionSemaphore() {
        RunContext runContext = (RunContext)RunContext.CURRENT.get();
        Semaphore semaphore = (Semaphore)runContext.getProperty((Object)LOOP_DETECTION_KEY);
        if (semaphore == null) {
            semaphore = new Semaphore(1);
            runContext.withProperty((Object)LOOP_DETECTION_KEY, (Object)semaphore);
        }
        return semaphore;
    }
}

