/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.perf.internal;

import java.util.Arrays;

public class PerformanceSampleSet {
    private final Object m_samplesLock = new Object();
    private final long[] m_samples;
    private int m_samplesLastIndex;
    private long m_samplesSum = 0L;

    public PerformanceSampleSet(int size, long initialValue) {
        this.m_samples = new long[size];
        Arrays.fill(this.m_samples, initialValue);
        this.m_samplesSum = (long)size * initialValue;
        this.m_samplesLastIndex = this.m_samples.length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(long millis) {
        if (millis < 0L) {
            millis = 0L;
        }
        Object object = this.m_samplesLock;
        synchronized (object) {
            long l = this.m_samplesSum;
            int i = (this.m_samplesLastIndex + 1) % this.m_samples.length;
            l -= this.m_samples[i];
            this.m_samples[i] = millis;
            this.m_samplesLastIndex = i;
            this.m_samplesSum = l += this.m_samples[i];
        }
    }

    public long getValue() {
        return this.m_samplesSum / (long)this.m_samples.length;
    }
}

