/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.pwd;

import java.util.Date;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.useradmin.DefaultPasswordForm;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.shared.services.common.pwd.IPasswordManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPolicyVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordPolicyVerifier.class);

    public boolean verify(String userId, int warnInAdvanceDays) {
        IPasswordManagementService service = (IPasswordManagementService)BEANS.get(IPasswordManagementService.class);
        if (service == null) {
            LOG.error("missing client service proxy for {}. Check registered beans.", (Object)IPasswordManagementService.class.getName());
            return false;
        }
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        if (desktop == null) {
            LOG.error("desktop is null");
            return false;
        }
        if (!desktop.isOpened()) {
            LOG.error("desktop is available, but there is not yet a GUI attached. Make sure to calll this verifier at earliest in the Desktop.execGuiAvailable callback");
            return false;
        }
        try {
            boolean changeNow = false;
            Date now = new Date();
            Date expiryDate = service.getPasswordExpirationDate(userId);
            if (expiryDate.after(now)) {
                long remainDays = (expiryDate.getTime() - now.getTime()) / 3600000L / 24L;
                if (remainDays < (long)warnInAdvanceDays) {
                    String header = remainDays == 0L ? TEXTS.get((String)"PasswordWillExpireHeaderX", (String[])new String[]{TEXTS.get((String)"Today")}) : (remainDays == 1L ? TEXTS.get((String)"PasswordWillExpireHeaderX", (String[])new String[]{TEXTS.get((String)"Tomorrow")}) : TEXTS.get((String)"PasswordWillExpireHeaderX", (String[])new String[]{TEXTS.get((String)"InDaysX", (String[])new String[]{"" + remainDays})}));
                    int answer = MessageBoxes.createYesNoCancel().withHeader(header).withBody(TEXTS.get((String)"PasswordWillExpireInfo")).show();
                    if (answer == 0) {
                        changeNow = true;
                    }
                }
            } else {
                MessageBoxes.createOk().withHeader(TEXTS.get((String)"PasswordHasExpiredTitle")).withBody(TEXTS.get((String)"PasswordHasExpiredHeader")).show();
                changeNow = true;
            }
            if (changeNow) {
                this.callPasswordForm(userId);
                expiryDate = service.getPasswordExpirationDate(userId);
            }
            return expiryDate.after(now);
        }
        catch (Exception t) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)t);
            return false;
        }
    }

    protected void callPasswordForm(String userId) {
        DefaultPasswordForm form = new DefaultPasswordForm();
        form.setUserId(userId);
        form.startChange();
        form.waitFor();
    }
}

