/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel.http;

import java.net.URL;
import java.util.List;
import org.eclipse.scout.rt.client.clientnotification.ClientNotificationDispatcher;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.services.common.perf.IPerformanceAnalyzerService;
import org.eclipse.scout.rt.client.servicetunnel.http.IClientServiceTunnel;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.servicetunnel.http.HttpServiceTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Replace
public class ClientHttpServiceTunnel
extends HttpServiceTunnel
implements IClientServiceTunnel {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHttpServiceTunnel.class);
    private boolean m_analyzeNetworkLatency = true;

    public ClientHttpServiceTunnel() {
    }

    public ClientHttpServiceTunnel(URL url) {
        super(url);
    }

    @Override
    public boolean isAnalyzeNetworkLatency() {
        return this.m_analyzeNetworkLatency;
    }

    @Override
    public void setAnalyzeNetworkLatency(boolean b) {
        this.m_analyzeNetworkLatency = b;
    }

    protected void afterTunnel(long t0, ServiceTunnelResponse serviceResponse) {
        IPerformanceAnalyzerService perf;
        if (this.isAnalyzeNetworkLatency() && (perf = (IPerformanceAnalyzerService)BEANS.opt(IPerformanceAnalyzerService.class)) != null) {
            long totalMillis = (System.nanoTime() - t0) / 1000000L;
            Long execMillis = serviceResponse.getProcessingDuration();
            if (execMillis != null) {
                perf.addNetworkLatencySample(totalMillis - execMillis);
                perf.addServerExecutionTimeSample(execMillis);
            } else {
                perf.addNetworkLatencySample(totalMillis);
            }
        }
        try {
            this.dispatchClientNotifications(serviceResponse.getNotifications());
        }
        catch (RuntimeException e) {
            LOG.error("Error during processing piggyback client notifictions.", (Throwable)e);
        }
    }

    protected void dispatchClientNotifications(List<ClientNotificationMessage> notifications) {
        if (CollectionUtility.isEmpty(notifications)) {
            return;
        }
        IBlockingCondition cond = Jobs.newBlockingCondition((boolean)true);
        Jobs.schedule(() -> {
            ClientNotificationDispatcher notificationDispatcher = (ClientNotificationDispatcher)BEANS.get(ClientNotificationDispatcher.class);
            notificationDispatcher.dispatchNotifications(notifications);
        }, (JobInput)Jobs.newInput().withRunContext((RunContext)ClientRunContexts.copyCurrent())).whenDone(event -> cond.setBlocking(false), null);
        cond.waitFor(new String[0]);
    }
}

