/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.accordion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.accordion.IAccordion;
import org.eclipse.scout.rt.client.ui.group.IGroup;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.classid.ITypeWithClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;

@ClassId(value="0f4a0100-ef2b-46e2-809b-56ed62c56006")
public abstract class AbstractAccordion
extends AbstractWidget
implements IAccordion {
    private Comparator<? extends IGroup> m_comparator;

    public AbstractAccordion() {
        this(true);
    }

    public AbstractAccordion(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setExclusiveExpand(this.getConfiguredExclusiveExpand());
        this.setScrollable(this.getConfiguredScrollable());
        OrderedCollection groups = new OrderedCollection();
        this.injectGroupsInternal((OrderedCollection<IGroup>)groups);
        this.setGroups(groups.getOrderedList());
    }

    @Override
    @Deprecated
    public ITypeWithClassId getContainer() {
        return this.getParent();
    }

    protected void injectGroupsInternal(OrderedCollection<IGroup> groups) {
        List<Class<? extends IGroup>> groupClasses = this.getConfiguredGroups();
        for (Class<? extends IGroup> groupClass : groupClasses) {
            IGroup group = this.createGroupInternal(groupClass);
            if (group == null) continue;
            groups.addOrdered((IOrdered)group);
        }
    }

    protected IGroup createGroupInternal(Class<? extends IGroup> tileClass) {
        return (IGroup)ConfigurationUtility.newInnerInstance((Object)this, tileClass);
    }

    protected List<Class<? extends IGroup>> getConfiguredGroups() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IGroup.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @Override
    public List<? extends IGroup> getGroups() {
        return CollectionUtility.arrayList((Collection)this.propertySupport.getPropertyList("groups"));
    }

    @Override
    public int getGroupCount() {
        return this.getGroupsInternal().size();
    }

    protected List<? extends IGroup> getGroupsInternal() {
        return this.propertySupport.getPropertyList("groups");
    }

    @Override
    public void setGroups(List<? extends IGroup> groups) {
        if (CollectionUtility.equalsCollection(this.getGroupsInternal(), groups, (boolean)true)) {
            return;
        }
        List existingGroups = (List)ObjectUtility.nvl(this.getGroupsInternal(), new ArrayList());
        groups = (List)ObjectUtility.nvl(groups, new ArrayList());
        ArrayList<IGroup> groupsToDelete = new ArrayList<IGroup>(existingGroups);
        groupsToDelete.removeAll(groups);
        this.deleteGroupsInternal(groupsToDelete);
        ArrayList<IGroup> groupsToInsert = new ArrayList<IGroup>(groups);
        groupsToInsert.removeAll(existingGroups);
        this.addGroupsInternal(groupsToInsert);
        this.sortInternal(groups);
        this.setGroupsInternal(groups);
    }

    protected void addGroupsInternal(List<IGroup> groupsToInsert) {
        for (IGroup group : groupsToInsert) {
            this.addGroupInternal(group);
        }
        if (this.isInitConfigDone()) {
            for (IGroup group : groupsToInsert) {
                group.init();
            }
        }
    }

    protected void addGroupInternal(IGroup group) {
        group.setParentInternal(this);
    }

    protected void deleteGroupsInternal(List<IGroup> groupsToDelete) {
        for (IGroup group : groupsToDelete) {
            this.deleteGroupInternal(group);
        }
    }

    protected void deleteGroupInternal(IGroup group) {
        group.dispose();
    }

    protected void setGroupsInternal(List<? extends IGroup> groups) {
        this.propertySupport.setPropertyList("groups", groups);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getGroups()});
    }

    @Override
    public void addGroups(List<? extends IGroup> groupsToAdd) {
        ArrayList<? extends IGroup> groups = new ArrayList<IGroup>(this.getGroupsInternal());
        groups.addAll(groupsToAdd);
        this.setGroups(groups);
    }

    @Override
    public void addGroup(IGroup group) {
        this.addGroups(CollectionUtility.arrayList((Object)group));
    }

    @Override
    public void deleteGroups(List<? extends IGroup> groupsToDelete) {
        ArrayList<? extends IGroup> groups = new ArrayList<IGroup>(this.getGroupsInternal());
        groups.removeAll(groupsToDelete);
        this.setGroups(groups);
    }

    @Override
    public void deleteGroup(IGroup group) {
        this.deleteGroups(CollectionUtility.arrayList((Object)group));
    }

    @Override
    public void deleteAllGroups() {
        this.setGroups(new ArrayList());
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredExclusiveExpand() {
        return true;
    }

    @Override
    public boolean isExclusiveExpand() {
        return this.propertySupport.getPropertyBool("exclusiveExpand");
    }

    @Override
    public void setExclusiveExpand(boolean exclusiveExpand) {
        this.propertySupport.setPropertyBool("exclusiveExpand", exclusiveExpand);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredScrollable() {
        return true;
    }

    @Override
    public boolean isScrollable() {
        return this.propertySupport.getPropertyBool("scrollable");
    }

    @Override
    public void setScrollable(boolean scrollable) {
        this.propertySupport.setPropertyBool("scrollable", scrollable);
    }

    @Override
    public void setComparator(Comparator<? extends IGroup> comparator) {
        this.setComparator(comparator, true);
    }

    @Override
    public void setComparator(Comparator<? extends IGroup> comparator, boolean sortNow) {
        if (this.m_comparator == comparator) {
            return;
        }
        this.m_comparator = comparator;
        if (sortNow) {
            this.sort();
        }
    }

    @Override
    public Comparator<? extends IGroup> getComparator() {
        return this.m_comparator;
    }

    protected Comparator<? extends IGroup> resolveComparator() {
        return this.getComparator();
    }

    @Override
    public void sort() {
        if (this.resolveComparator() == null) {
            return;
        }
        List<? extends IGroup> groups = this.getGroups();
        this.sortInternal(groups);
        this.setGroupsInternal(groups);
    }

    public void sortInternal(List<? extends IGroup> groups) {
        Comparator<? extends IGroup> comparator = this.resolveComparator();
        if (comparator == null) {
            return;
        }
        groups.sort(comparator);
    }
}

