/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public final class ActionUtility {
    public static final Predicate<IAction> FALSE_FILTER = action -> false;
    public static final Predicate<IAction> TRUE_FILTER = action -> true;

    private ActionUtility() {
    }

    public static <T extends IAction> List<T> visibleNormalizedActions(List<T> actionNodes) {
        return ActionUtility.normalizedActions(actionNodes, ActionUtility.createVisibleFilter());
    }

    public static <T extends IAction> List<T> normalizedActions(List<T> actionNodes, Predicate<IAction> filter) {
        if (actionNodes == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<T> cleanedActions = ActionUtility.getActions(actionNodes, filter);
        ActionUtility.normalizeSeparators(cleanedActions);
        return cleanedActions;
    }

    public static <T extends IAction> void normalizeSeparators(List<T> actions) {
        IAction prevAction = null;
        ListIterator<T> it = actions.listIterator();
        while (it.hasNext()) {
            IAction currentAction = (IAction)it.next();
            if (currentAction.isSeparator() && (prevAction == null || prevAction.isSeparator())) {
                it.remove();
                continue;
            }
            prevAction = currentAction;
        }
        while (it.hasPrevious()) {
            IAction previous = (IAction)it.previous();
            if (!previous.isSeparator()) break;
            it.remove();
        }
    }

    public static <T extends IAction> List<T> getActions(List<T> actions, Predicate<IAction> filter) {
        if (actions != null) {
            ArrayList<IAction> result = new ArrayList<IAction>(actions.size());
            for (IAction a : actions) {
                if (a.isSeparator()) {
                    result.add(a);
                    continue;
                }
                if (!filter.test(a)) continue;
                result.add(a);
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static Predicate<IAction> createVisibleFilter() {
        return new Predicate<IAction>(){

            @Override
            public boolean test(IAction action) {
                if (action.isVisible()) {
                    if (action instanceof IActionNode && ((IActionNode)action).hasChildActions()) {
                        List visibleChildActions = ActionUtility.getActions(((IActionNode)action).getChildActions(), this);
                        return !visibleChildActions.isEmpty();
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<IAction> createMenuFilterMenuTypes(boolean visibleOnly, IMenuType ... menuTypes) {
        return ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object[])menuTypes), visibleOnly);
    }

    public static Predicate<IAction> createMenuFilterMenuTypes(Set<? extends IMenuType> menuTypes, boolean visibleOnly) {
        return new MenuTypeFilter(menuTypes, visibleOnly);
    }

    @SafeVarargs
    public static Predicate<IAction> createCombinedFilter(Predicate<IAction> ... actionFilters) {
        if (actionFilters != null) {
            return action -> {
                Predicate[] predicateArray2 = actionFilters;
                int n = actionFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate f = predicateArray2[n2];
                    if (!f.test(action)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            };
        }
        return TRUE_FILTER;
    }

    public static class MenuTypeFilter
    implements Predicate<IAction> {
        private final boolean m_visibleOnly;
        private final Set<? extends IMenuType> m_menuTypes;

        public MenuTypeFilter(Set<? extends IMenuType> menuTypes, boolean visibleOnly) {
            this.m_menuTypes = menuTypes;
            this.m_visibleOnly = visibleOnly;
        }

        @Override
        public boolean test(IAction action) {
            if (action instanceof IMenu) {
                IMenu menu = (IMenu)action;
                if (this.isVisibleOnly() && !menu.isVisible()) {
                    return false;
                }
                if (menu.hasChildActions()) {
                    return !ActionUtility.normalizedActions(menu.getChildActions(), this).isEmpty();
                }
                if (this.getMenuTypes() != null) {
                    for (IMenuType iMenuType : this.getMenuTypes()) {
                        if (!menu.getMenuTypes().contains(iMenuType)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public Set<? extends IMenuType> getMenuTypes() {
            return this.m_menuTypes;
        }

        public boolean isVisibleOnly() {
            return this.m_visibleOnly;
        }
    }
}

