/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.ValueFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.IValueFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="c07663cf-fbe6-4514-8653-81e547b58445")
public class ValueFieldContextMenu
extends FormFieldContextMenu<IValueField<?>>
implements IValueFieldContextMenu {
    public ValueFieldContextMenu(IValueField owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(this.getMenuTypesForValue(((IValueField)this.getContainer()).getValue()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        IValueField container = (IValueField)this.getContainer();
        if (container != null) {
            Object ownerValue = container.getValue();
            this.setCurrentMenuTypes(this.getMenuTypesForValue(ownerValue));
            this.visit(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()), IMenu.class);
        }
        this.calculateLocalVisibility();
    }

    @Override
    protected boolean isOwnerPropertyChangedListenerRequired() {
        return true;
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        super.handleOwnerPropertyChanged(evt);
        if ("value".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }

    protected Set<ValueFieldMenuType> getMenuTypesForValue(Object value) {
        if (value == null) {
            return CollectionUtility.hashSet((Object)ValueFieldMenuType.Null);
        }
        return CollectionUtility.hashSet((Object)ValueFieldMenuType.NotNull);
    }
}

