/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.action.tree.IActionNodeExtension;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.menu.IReadOnlyMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.OrderedComparator;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;

@ClassId(value="bacb13e3-6627-4d87-bb8c-fc578ceb1bfe")
public abstract class AbstractActionNode<T extends IActionNode>
extends AbstractAction
implements IActionNode<T>,
IContributionOwner {
    private IContributionOwner m_contributionHolder;

    public AbstractActionNode() {
    }

    public AbstractActionNode(boolean callInitializer) {
        super(callInitializer);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <TYPE> List<TYPE> getContributionsByClass(Class<TYPE> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <TYPE> TYPE getContribution(Class<TYPE> contribution) {
        return (TYPE)this.m_contributionHolder.getContribution(contribution);
    }

    public final <TYPE> TYPE optContribution(Class<TYPE> contribution) {
        return (TYPE)this.m_contributionHolder.optContribution(contribution);
    }

    private List<Class<? extends IActionNode>> getConfiguredChildActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IActionNode.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        OrderedCollection actionNodes = new OrderedCollection();
        List<Class<IActionNode>> configuredChildActions = this.getConfiguredChildActions();
        for (Class<IActionNode> a : configuredChildActions) {
            IActionNode node = (IActionNode)ConfigurationUtility.newInnerInstance((Object)this, a);
            actionNodes.addOrdered((IOrdered)node);
        }
        this.m_contributionHolder = new ContributionComposite((Object)this);
        List contributedActions = this.m_contributionHolder.getContributionsByClass(IActionNode.class);
        for (IActionNode n : contributedActions) {
            actionNodes.addOrdered((IOrdered)n);
        }
        this.injectActionNodesInternal(actionNodes);
        this.setChildActions(actionNodes.getOrderedList());
    }

    protected void injectActionNodesInternal(OrderedCollection<T> actionNodes) {
    }

    protected static <T extends IActionNode> void connectActionNode(T child, IActionNode<T> parent) {
        IWidget containerOfParent;
        IWidget containerOfChild;
        Assertions.assertNotNull(child);
        if (child instanceof IReadOnlyMenu) {
            return;
        }
        if (parent == null) {
            child.setParentInternal(null);
            child.setContainerInternal(null);
            return;
        }
        IWidget currentChildParent = child.getParent();
        if (currentChildParent != parent) {
            Assertions.assertNull((Object)currentChildParent, (String)"Action '{}' cannot be added to '{}' because it is still connected to '{}'.", (Object[])new Object[]{child, parent, child.getParent()});
            child.setParentInternal(parent);
        }
        if ((containerOfChild = child.getContainer()) != (containerOfParent = parent.getContainer())) {
            child.setContainerInternal(containerOfParent);
        }
    }

    @Override
    public void setContainerInternal(IWidget container) {
        super.setContainerInternal(container);
        List<IActionNode> childActions = this.getChildActionsInternal();
        if (childActions == null || childActions.isEmpty()) {
            return;
        }
        childActions.forEach(a -> AbstractActionNode.connectActionNode(a, this));
    }

    private List<T> getChildActionsInternal() {
        return this.propertySupport.getPropertyList("childActions");
    }

    @Override
    public boolean hasChildActions() {
        return CollectionUtility.hasElements(this.getChildActionsInternal());
    }

    @Override
    public int getChildActionCount() {
        return CollectionUtility.size(this.getChildActionsInternal());
    }

    @Override
    public List<T> getChildActions() {
        return CollectionUtility.arrayList(this.getChildActionsInternal());
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getChildActionsInternal()});
    }

    @Override
    public void setChildActions(Collection<? extends T> newList) {
        this.removeChildActions(this.getChildActionsInternal());
        this.addChildActions(newList);
    }

    @Override
    public void addChildAction(T action) {
        this.addChildActions(CollectionUtility.arrayList(action));
    }

    @Override
    public void addChildActions(Collection<? extends T> actionList) {
        ArrayList normalizedList = CollectionUtility.arrayListWithoutNullElements(actionList);
        if (normalizedList.isEmpty()) {
            return;
        }
        List<T> childList = this.getChildActionsInternal();
        if (childList == null) {
            childList = new ArrayList<T>(normalizedList.size());
        }
        childList.addAll(normalizedList);
        childList.sort((Comparator<T>)new OrderedComparator());
        for (IActionNode child : normalizedList) {
            AbstractActionNode.connectActionNode(child, this);
        }
        this.propertySupport.setPropertyAlwaysFire("childActions", childList);
    }

    @Override
    public void removeChildAction(T action) {
        this.removeChildActions(CollectionUtility.arrayList(action));
    }

    @Override
    public void removeChildActions(Collection<? extends T> actionList) {
        ArrayList normalizedList = CollectionUtility.arrayListWithoutNullElements(actionList);
        if (normalizedList.isEmpty()) {
            return;
        }
        List<T> childList = this.getChildActionsInternal();
        if (childList == null || childList.isEmpty()) {
            return;
        }
        boolean listChanged = false;
        for (IActionNode a : normalizedList) {
            if (!childList.remove(a)) continue;
            listChanged = true;
            AbstractActionNode.connectActionNode(a, null);
        }
        if (listChanged) {
            this.propertySupport.setPropertyAlwaysFire("childActions", childList);
        }
    }

    protected IActionNodeExtension<T, ? extends AbstractActionNode<T>> createLocalExtension() {
        return new LocalActionNodeExtension(this);
    }

    protected static class LocalActionNodeExtension<T extends IActionNode, OWNER extends AbstractActionNode<T>>
    extends AbstractAction.LocalActionExtension<OWNER>
    implements IActionNodeExtension<T, OWNER> {
        public LocalActionNodeExtension(OWNER owner) {
            super(owner);
        }
    }
}

