/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.breadcrumbbar;

import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.basic.breadcrumbbar.BreadcrumbItemEvent;
import org.eclipse.scout.rt.client.ui.basic.breadcrumbbar.BreadcrumbItemListener;
import org.eclipse.scout.rt.client.ui.basic.breadcrumbbar.IBreadcrumbItem;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;

@ClassId(value="259a8161-3a96-446e-b34e-e956acfbf61e")
public abstract class AbstractBreadcrumbItem
extends AbstractAction
implements IBreadcrumbItem {
    private FastListenerList<BreadcrumbItemListener> m_listenerList = new FastListenerList();

    public AbstractBreadcrumbItem() {
        this(true);
    }

    public AbstractBreadcrumbItem(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setRef(this.getConfiguredRef());
    }

    @Override
    protected void doActionInternal() {
        super.doActionInternal();
        this.fireBreadcrumbAction();
    }

    @Override
    public FastListenerList<BreadcrumbItemListener> breadcrumbItemListeners() {
        return this.m_listenerList;
    }

    protected void fireBreadcrumbAction() {
        this.fireBreadcrumbEvent(new BreadcrumbItemEvent(this, 10));
    }

    protected void fireBreadcrumbEvent(BreadcrumbItemEvent e) {
        this.breadcrumbItemListeners().list().forEach(listener -> listener.breadcrumbItemChanged(e));
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=1000.0)
    protected String getConfiguredRef() {
        return null;
    }

    @Override
    public String getRef() {
        return this.propertySupport.getPropertyString("ref");
    }

    @Override
    public void setRef(String value) {
        this.propertySupport.setProperty("ref", (Object)value);
    }
}

