/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

public class DisplayModeOptions {
    private long m_interval = 0L;
    private int m_labelPeriod = 1;
    private int m_firstHourOfDay = 0;
    private int m_lastHourOfDay = 23;
    private int m_minSelectionIntervalCount = 1;

    public long getInterval() {
        return this.m_interval;
    }

    public int getLabelPeriod() {
        return this.m_labelPeriod;
    }

    public int getFirstHourOfDay() {
        return this.m_firstHourOfDay;
    }

    public int getLastHourOfDay() {
        return this.m_lastHourOfDay;
    }

    public int getMinSelectionIntervalCount() {
        return this.m_minSelectionIntervalCount;
    }

    public DisplayModeOptions withInterval(long interval) {
        this.m_interval = interval;
        return this;
    }

    public DisplayModeOptions withLabelPeriod(int labelPeriod) {
        this.m_labelPeriod = labelPeriod;
        return this;
    }

    public DisplayModeOptions withFirstHourOfDay(int firstHourOfDay) {
        this.m_firstHourOfDay = this.validHour(firstHourOfDay);
        return this;
    }

    public DisplayModeOptions withLastHourOfDay(int lastHourOfDay) {
        this.m_lastHourOfDay = this.validHour(lastHourOfDay);
        return this;
    }

    protected int validHour(int hour) {
        if (hour < 0) {
            return 0;
        }
        if (hour > 23) {
            return 23;
        }
        return hour;
    }

    public DisplayModeOptions withMinSelectionIntervalCount(int minSelectionIntervalCount) {
        this.m_minSelectionIntervalCount = minSelectionIntervalCount;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_firstHourOfDay;
        result = 31 * result + (int)(this.m_interval ^ this.m_interval >>> 32);
        result = 31 * result + this.m_labelPeriod;
        result = 31 * result + this.m_lastHourOfDay;
        result = 31 * result + this.m_minSelectionIntervalCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisplayModeOptions other = (DisplayModeOptions)obj;
        if (this.m_firstHourOfDay != other.m_firstHourOfDay) {
            return false;
        }
        if (this.m_interval != other.m_interval) {
            return false;
        }
        if (this.m_labelPeriod != other.m_labelPeriod) {
            return false;
        }
        if (this.m_lastHourOfDay != other.m_lastHourOfDay) {
            return false;
        }
        return this.m_minSelectionIntervalCount == other.m_minSelectionIntervalCount;
    }
}

