/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerEvent;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class PlannerEventBuffer
extends AbstractEventBuffer<PlannerEvent> {
    @Override
    protected List<PlannerEvent> coalesce(List<PlannerEvent> events) {
        this.removeObsolete(events);
        this.replacePrevious(events, 100, 101);
        this.removeEmptyEvents(events);
        this.removeIdenticalEvents(events);
        this.coalesceSameType(events);
        return events;
    }

    protected void removeObsolete(List<PlannerEvent> events) {
        int j = 0;
        while (j < events.size() - 1) {
            int i = events.size() - 1 - j;
            PlannerEvent event = events.get(i);
            int type = event.getType();
            if (type == 105) {
                this.remove(this.getResourceRelatedEvents(), events.subList(0, i));
            } else if (this.isIgnorePrevious(type)) {
                this.remove(type, events.subList(0, i));
            } else if (type == 102) {
                List<Resource> remainingResources = this.removeResourcesFromPreviousEvents(event.getResources(), events.subList(0, i), 100);
                event.setResources(remainingResources);
            }
            ++j;
        }
    }

    protected List<Resource> removeResourcesFromPreviousEvents(List<? extends Resource> resourcesToRemove, List<PlannerEvent> events, Integer ... creationTypes) {
        List<Integer> creationTypesList = Arrays.asList(creationTypes);
        ArrayList<Resource> remainingResources = new ArrayList<Resource>();
        for (Resource resource : resourcesToRemove) {
            boolean resourceRemovedFromCreationEvent = false;
            ListIterator<PlannerEvent> it = events.listIterator(events.size());
            while (it.hasPrevious()) {
                PlannerEvent event = it.previous();
                boolean removed = this.removeResource(event, resource);
                if (removed && creationTypesList.contains(event.getType())) {
                    resourceRemovedFromCreationEvent = true;
                }
                if (!this.isResourceOrderUnchanged(event.getType())) break;
            }
            if (resourceRemovedFromCreationEvent) continue;
            remainingResources.add(resource);
        }
        return remainingResources;
    }

    protected boolean removeResource(PlannerEvent event, Resource resourceToRemove) {
        boolean removed = false;
        List<? extends Resource> resources = event.getResources();
        Iterator<? extends Resource> it = resources.iterator();
        while (it.hasNext()) {
            Resource resource = it.next();
            if (resource != resourceToRemove) continue;
            it.remove();
            removed = true;
        }
        event.setResources(resources);
        return removed;
    }

    protected void replacePrevious(List<PlannerEvent> events, int oldType, int newType) {
        int j = 0;
        while (j < events.size() - 1) {
            int i = events.size() - 1 - j;
            PlannerEvent event = events.get(i);
            if (event.getType() == newType) {
                this.updatePreviousResource(event, events.subList(0, i), oldType);
            }
            ++j;
        }
    }

    protected void coalesceSameType(List<PlannerEvent> events) {
        int j = 0;
        while (j < events.size() - 1) {
            int i = events.size() - 1 - j;
            PlannerEvent event = events.get(i);
            if (this.isCoalesceConsecutivePrevious(event.getType())) {
                this.coalesceConsecutivePrevious(event, events.subList(0, i));
            }
            ++j;
        }
    }

    protected void updatePreviousResource(PlannerEvent event, List<PlannerEvent> events, int type) {
        ListIterator<PlannerEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            PlannerEvent previous = it.previous();
            if (previous.getType() == type) {
                List<? extends Resource> resources = event.getResources();
                this.replaceResources(previous, resources);
                event.setResources(resources);
            }
            if (!this.isResourceOrderUnchanged(previous.getType())) break;
        }
    }

    protected void replaceResources(PlannerEvent event, List<? extends Resource> newResources) {
        Iterator<? extends Resource> it = newResources.iterator();
        while (it.hasNext()) {
            Resource newResource = it.next();
            boolean replaced = this.tryReplaceResource(event, newResource);
            if (!replaced) continue;
            it.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean tryReplaceResource(PlannerEvent event, Resource newResource) {
        ArrayList<void> targetResources = new ArrayList<void>();
        boolean replaced = false;
        for (Resource resource : event.getResources()) {
            void var5_6;
            if (resource == newResource) {
                Resource resource2 = newResource;
                replaced = true;
            }
            targetResources.add(var5_6);
        }
        event.setResources(targetResources);
        return replaced;
    }

    protected void coalesceConsecutivePrevious(PlannerEvent event, List<PlannerEvent> list) {
        ListIterator<PlannerEvent> it = list.listIterator(list.size());
        while (it.hasPrevious()) {
            PlannerEvent previous = it.previous();
            if (event.getType() == previous.getType()) {
                this.merge(previous, event);
                it.remove();
                continue;
            }
            if (this.isResourceRelatedEvent(event.getType()) != this.isResourceRelatedEvent(previous.getType())) continue;
            return;
        }
    }

    protected PlannerEvent merge(PlannerEvent first, PlannerEvent second) {
        second.setResources(this.mergeResources(first.getResources(), second.getResources()));
        return second;
    }

    protected List<Resource> mergeResources(List<? extends Resource> first, List<? extends Resource> second) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashSet<? extends Resource> secondResourceSet = new HashSet<Resource>(second);
        for (Resource resource : first) {
            if (secondResourceSet.contains(resource)) continue;
            resources.add(resource);
        }
        resources.addAll(second);
        return resources;
    }

    protected PlannerEvent findInsertionBeforeResourceOrderChanged(List<PlannerEvent> events) {
        ListIterator<PlannerEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            PlannerEvent previous = it.previous();
            if (previous.getType() == 100) {
                return previous;
            }
            if (!this.isResourceOrderUnchanged(previous.getType())) break;
        }
        return null;
    }

    protected void removeEmptyEvents(List<PlannerEvent> events) {
        events.removeIf(event -> this.isResourcesRequired(event.getType()) && event.getResources().isEmpty());
    }

    protected void removeIdenticalEvents(List<PlannerEvent> events) {
        int i = 0;
        while (i < events.size()) {
            PlannerEvent event = events.get(i);
            List<PlannerEvent> subList = events.subList(i + 1, events.size());
            Iterator<PlannerEvent> it = subList.iterator();
            while (it.hasNext()) {
                PlannerEvent next = it.next();
                if (next.getType() != event.getType()) break;
                if (!this.isIdenticalEvent(event, next)) continue;
                it.remove();
            }
            ++i;
        }
    }

    @Override
    protected boolean isIdenticalEvent(PlannerEvent event1, PlannerEvent event2) {
        if (event1 == null && event2 == null) {
            return true;
        }
        if (event1 == null || event2 == null) {
            return false;
        }
        boolean identical = event1.getType() == event2.getType() && CollectionUtility.equalsCollection(event1.getResources(), event2.getResources(), (boolean)true) && CollectionUtility.equalsCollection(event1.getPopupMenus(), event2.getPopupMenus());
        return identical;
    }

    protected boolean isResourceOrderUnchanged(int type) {
        switch (type) {
            case 101: 
            case 103: {
                return true;
            }
        }
        return false;
    }

    protected Set<Integer> getResourceRelatedEvents() {
        HashSet<Integer> res = new HashSet<Integer>();
        res.add(105);
        res.add(102);
        res.add(100);
        res.add(101);
        res.add(103);
        return res;
    }

    protected boolean isResourceRelatedEvent(int type) {
        return this.getResourceRelatedEvents().contains(type);
    }

    protected boolean isIgnorePrevious(int type) {
        switch (type) {
            case 103: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    protected boolean isCoalesceConsecutivePrevious(int type) {
        switch (type) {
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    protected boolean isResourcesRequired(int type) {
        switch (type) {
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }
}

