/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.HeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.shared.data.basic.table.SortSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnSet {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnSet.class);
    private final AbstractTable m_table;
    private final List<IColumn<?>> m_columns;
    private final List<IColumn<?>> m_userSortColumns;
    private final List<IColumn<?>> m_permanentHeadSortColumns;
    private final List<IColumn<?>> m_permanentTailSortColumns;
    private int[] m_keyIndexes = new int[0];
    private int[] m_parentKeyIndexes = new int[0];
    private int[] m_displayableIndexes = new int[0];
    private int[] m_visibleIndexes = new int[0];
    private final Map<Class, IColumn> m_classIndexes = new HashMap<Class, IColumn>();
    private final Map<String, IColumn> m_idIndexes = new HashMap<String, IColumn>();
    private final Map<Class<?>, Class<? extends IColumn>> m_columnReplacements;
    private final P_ColumnListener m_columnListener = new P_ColumnListener();

    public ColumnSet(AbstractTable table, List<IColumn<?>> columns) {
        ArrayList columnArray = new ArrayList(columns.size());
        for (IColumn<?> c : columns) {
            columnArray.add(c.getClass());
        }
        Map replacements = ConfigurationUtility.getReplacementMapping(columnArray);
        if (replacements.isEmpty()) {
            replacements = null;
        }
        this.m_columnReplacements = replacements;
        this.m_table = table;
        this.m_columns = new ArrayList(columns.size());
        this.m_userSortColumns = new ArrayList();
        this.m_permanentHeadSortColumns = new ArrayList();
        this.m_permanentTailSortColumns = new ArrayList();
        int index = 0;
        for (IColumn<?> col : columns) {
            if (col instanceof AbstractColumn) {
                ((AbstractColumn)col).setColumnIndexInternal(index);
                ((AbstractColumn)col).setTableInternal(this.m_table);
            }
            this.rebuildHeaderCell(col);
            this.m_columns.add(col);
            this.m_classIndexes.put(col.getClass(), col);
            this.m_idIndexes.put(col.getColumnId(), col);
            ++index;
        }
        this.reorganizeIndexes();
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        void var5_6;
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        int n = this.getColumnCount();
        TreeMap<CompositeObject, IColumn> sortMap = new TreeMap<CompositeObject, IColumn>();
        int viewIndex = 0;
        boolean bl = false;
        while (var5_6 < n) {
            IColumn col = this.getColumn((int)var5_6);
            double viewHint = col.getVisibleColumnIndexHint();
            if (viewHint < 0.0) {
                viewHint = col.getOrder();
            }
            if (viewHint < 0.0) {
                viewHint = viewIndex;
            }
            sortMap.put(new CompositeObject(new Object[]{viewHint, viewIndex}), col);
            ++viewIndex;
            ++var5_6;
        }
        viewIndex = 0;
        for (Map.Entry entry : sortMap.entrySet()) {
            ((IColumn)entry.getValue()).setVisibleColumnIndexHint(viewIndex);
            ++viewIndex;
        }
        this.reorganizeIndexes();
        this.applySortingAndGrouping(null);
        if (this.getVisibleColumnCount() == 0) {
            viewIndex = 0;
            for (IColumn iColumn : this.getColumns()) {
                if (iColumn.isDisplayable() && iColumn.isInitialVisible()) {
                    iColumn.setVisible(true);
                } else {
                    iColumn.setVisible(false);
                }
                iColumn.setWidth(iColumn.getInitialWidth());
                iColumn.setVisibleColumnIndexHint(viewIndex);
                prefs.removeAllTableColumnPreferences(iColumn, null, true);
                ++viewIndex;
            }
            this.reorganizeIndexes();
        }
        this.checkMultiline();
    }

    protected void initColumns() {
        for (IColumn<?> c : this.getColumns()) {
            c.removePropertyChangeListener(this.m_columnListener);
            c.addPropertyChangeListener(this.m_columnListener);
            try {
                c.initColumn();
            }
            catch (Exception t) {
                LOG.error("Could not init column {}", c, (Object)t);
            }
        }
        this.initialize();
    }

    protected void disposeColumns() {
        for (IColumn<?> c : this.getColumns()) {
            try {
                c.disposeColumn();
                c.removePropertyChangeListener(this.m_columnListener);
            }
            catch (Exception t) {
                LOG.error("Could not dispose column {}", c, (Object)t);
            }
        }
    }

    private P_SortingAndGroupingConfig createSortingAndGroupingConfig(IColumn<?> col, String configName) {
        if (col.isInitialAlwaysIncludeSortAtBegin() || col.isInitialAlwaysIncludeSortAtEnd()) {
            return this.createSortingAndGroupingConfig(col);
        }
        P_SortingAndGroupingConfig config = new P_SortingAndGroupingConfig();
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        config.setSortIndex(prefs.getTableColumnSortIndex(col, col.getInitialSortIndex(), configName));
        config.setAscending(prefs.getTableColumnSortAscending(col, col.isInitialSortAscending(), configName));
        config.setGrouped(prefs.getTableColumnGrouped(col, col.isInitialGrouped(), configName));
        if (col instanceof INumberColumn) {
            config.setAggregationFunction(prefs.getTableColumnAggregationFunction(col, ((INumberColumn)col).getInitialAggregationFunction(), configName));
        }
        return config;
    }

    private P_SortingAndGroupingConfig createSortingAndGroupingConfig(IColumn<?> col) {
        P_SortingAndGroupingConfig config = new P_SortingAndGroupingConfig();
        config.setSortIndex(col.getInitialSortIndex());
        config.setAscending(col.isInitialSortAscending());
        config.setGrouped(col.isInitialGrouped());
        if (col instanceof INumberColumn) {
            config.setAggregationFunction(((INumberColumn)col).getInitialAggregationFunction());
        }
        return config;
    }

    private void applySortingAndGroupingInternal(Map<IColumn, P_SortingAndGroupingConfig> columnConfigs) {
        TreeMap sortMap = new TreeMap();
        int index = 0;
        for (IColumn<?> col : this.getColumns()) {
            int sortIndex = -1;
            if (col.isInitialAlwaysIncludeSortAtBegin()) {
                sortIndex = col.getInitialSortIndex();
                if (sortIndex < 0) {
                    LOG.warn("AlwaysIncludeSortAtBegin is set but no sort index configured. Table: {}", (Object)this.m_table.getClass().getName());
                }
            } else if (col.isInitialAlwaysIncludeSortAtEnd()) {
                sortIndex = col.getInitialSortIndex();
                if (sortIndex < 0) {
                    LOG.warn("AlwaysIncludeSortAtEnd is set but no sort index configured. Table: {}", (Object)this.m_table.getClass().getName());
                }
            } else {
                sortIndex = columnConfigs.get(col).getSortIndex();
            }
            if (sortIndex >= 0) {
                sortMap.put(new CompositeObject(new Object[]{sortIndex, index}), col);
            }
            if (col instanceof INumberColumn) {
                ((INumberColumn)col).setAggregationFunction(columnConfigs.get(col).getAggregationFunction());
            }
            ++index;
        }
        this.clearSortColumns();
        this.clearPermanentHeadSortColumns();
        this.clearPermanentTailSortColumns();
        for (IColumn col : sortMap.values()) {
            if (col.isInitialAlwaysIncludeSortAtBegin()) {
                boolean asc = col.isInitialSortAscending();
                this.addPermanentHeadSortColumn(col, asc);
                continue;
            }
            if (col.isInitialAlwaysIncludeSortAtEnd()) {
                boolean asc = col.isInitialSortAscending();
                this.addPermanentTailSortColumn(col, asc);
                continue;
            }
            boolean asc = columnConfigs.get(col).isAscending();
            this.addSortColumn(col, asc);
        }
        this.applyGrouping(columnConfigs);
    }

    public void resetSortingAndGrouping() {
        HashMap<IColumn, P_SortingAndGroupingConfig> columnConfigs = new HashMap<IColumn, P_SortingAndGroupingConfig>();
        for (IColumn<?> col : this.getColumns()) {
            columnConfigs.put(col, this.createSortingAndGroupingConfig(col));
        }
        this.applySortingAndGroupingInternal(columnConfigs);
    }

    public void applySortingAndGrouping(String configName) {
        HashMap<IColumn, P_SortingAndGroupingConfig> columnConfigs = new HashMap<IColumn, P_SortingAndGroupingConfig>();
        for (IColumn<?> col : this.getColumns()) {
            columnConfigs.put(col, this.createSortingAndGroupingConfig(col, configName));
        }
        this.applySortingAndGroupingInternal(columnConfigs);
        this.m_table.sort();
    }

    private void applyGrouping(Map<IColumn, P_SortingAndGroupingConfig> columnConfigs) {
        for (IColumn<?> col : this.getColumns()) {
            if (col.getSortIndex() >= 0 || !col.isGroupingActive()) continue;
            LOG.warn("Column marked as grouped but no sort index set. Column will not be grouped");
            ((HeaderCell)col.getHeaderCell()).setGroupingActive(false);
        }
        this.applyGroupingConfiguration(columnConfigs, this.getPermanentHeadSortColumns(), true);
        boolean valid = this.isUserColumnGroupingAllowed();
        this.applyGroupingConfiguration(columnConfigs, this.getUserSortColumns(), valid);
    }

    private void applyGroupingConfiguration(Map<IColumn, P_SortingAndGroupingConfig> columnConfigs, List<IColumn<?>> columns, boolean initiallyValid) {
        boolean allPreviousColumnsGroupedAndVisible = initiallyValid;
        for (IColumn<?> col : columns) {
            boolean grouped = columnConfigs.get(col).isGrouped();
            HeaderCell headerCell = (HeaderCell)col.getHeaderCell();
            if (allPreviousColumnsGroupedAndVisible) {
                if (grouped && col.isVisible()) {
                    headerCell.setGroupingActive(true);
                    continue;
                }
                headerCell.setGroupingActive(false);
                allPreviousColumnsGroupedAndVisible = false;
                continue;
            }
            if (grouped) {
                LOG.warn("Invalid column grouping config. Column marked as grouped but there are non-grouped or non-visible sort columns with smaller sort index. Grouping will be set to false.");
            }
            headerCell.setGroupingActive(false);
        }
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public int getKeyColumnCount() {
        return this.m_keyIndexes.length;
    }

    public int getDisplayableColumnCount() {
        return this.m_displayableIndexes.length;
    }

    public int getVisibleColumnCount() {
        return this.m_visibleIndexes.length;
    }

    public int[] getKeyColumnIndexes() {
        int[] a = new int[this.m_keyIndexes.length];
        System.arraycopy(this.m_keyIndexes, 0, a, 0, a.length);
        return a;
    }

    public int[] getParentKeyColumnIndexes() {
        int[] a = new int[this.m_parentKeyIndexes.length];
        System.arraycopy(this.m_parentKeyIndexes, 0, a, 0, a.length);
        return a;
    }

    public int[] getAllColumnIndexes() {
        int[] a = new int[this.m_columns.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = i;
            ++i;
        }
        return a;
    }

    public List<IColumn<?>> getAllColumnsInUserOrder() {
        List<IColumn<?>> visibleCols = this.getVisibleColumns();
        int counter = 0;
        TreeMap sortMap = new TreeMap();
        for (IColumn<?> col : visibleCols) {
            sortMap.put(new CompositeObject(new Object[]{col.getVisibleColumnIndexHint(), ++counter}), col);
        }
        for (IColumn<?> column : this.getColumns()) {
            if (column.isDisplayable() && column.isVisible()) continue;
            sortMap.put(new CompositeObject(new Object[]{column.getVisibleColumnIndexHint(), ++counter}), column);
        }
        return CollectionUtility.arrayList(sortMap.values());
    }

    public int[] getDisplayableColumnIndexes() {
        int[] a = new int[this.m_displayableIndexes.length];
        System.arraycopy(this.m_displayableIndexes, 0, a, 0, a.length);
        return a;
    }

    public int[] getVisibleColumnIndexes() {
        int[] a = new int[this.m_visibleIndexes.length];
        System.arraycopy(this.m_visibleIndexes, 0, a, 0, a.length);
        return a;
    }

    public int getKeyColumnIndex(int keyIndex) {
        return this.m_keyIndexes[keyIndex];
    }

    public int getDisplayableColumnIndex(int displayableIndex) {
        return this.m_displayableIndexes[displayableIndex];
    }

    public int getVisibleColumnIndex(int visibleIndex) {
        return this.m_visibleIndexes[visibleIndex];
    }

    public IColumn getColumn(int index) {
        if (index >= 0 && index < this.m_columns.size()) {
            return this.m_columns.get(index);
        }
        return null;
    }

    public <T extends IColumn> T getColumnByClass(Class<T> c) {
        Class<T> columnClass = this.getReplacingColumnClass(c);
        IColumn col = this.m_classIndexes.get(columnClass);
        return (T)col;
    }

    public <T extends IColumn> T getColumnById(String id) {
        return (T)this.m_idIndexes.get(id);
    }

    private <T extends IColumn> Class<? extends T> getReplacingColumnClass(Class<T> c) {
        Class<? extends IColumn> replacingColumnClass;
        if (this.m_columnReplacements != null && (replacingColumnClass = this.m_columnReplacements.get(c)) != null) {
            return replacingColumnClass;
        }
        return c;
    }

    public IColumn getDisplayableColumn(int index) {
        if (index >= 0 && index < this.m_displayableIndexes.length) {
            return this.m_columns.get(this.m_displayableIndexes[index]);
        }
        return null;
    }

    public IColumn getVisibleColumn(int index) {
        if (index >= 0 && index < this.m_visibleIndexes.length) {
            return this.m_columns.get(this.m_visibleIndexes[index]);
        }
        return null;
    }

    public List<IColumn<?>> getColumns() {
        return CollectionUtility.arrayList(this.m_columns);
    }

    public List<IColumn<?>> getKeyColumns() {
        ArrayList keyColumns = new ArrayList(this.m_keyIndexes.length);
        int[] nArray = this.m_keyIndexes;
        int n = this.m_keyIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int m_keyIndexe = nArray[n2];
            keyColumns.add(this.getColumn(m_keyIndexe));
            ++n2;
        }
        return keyColumns;
    }

    public List<IColumn<?>> getDisplayableColumns() {
        ArrayList a = new ArrayList(this.m_displayableIndexes.length);
        int[] nArray = this.m_displayableIndexes;
        int n = this.m_displayableIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int m_displayableIndexe = nArray[n2];
            a.add(this.getColumn(m_displayableIndexe));
            ++n2;
        }
        return a;
    }

    public List<IColumn<?>> getVisibleColumns() {
        ArrayList a = new ArrayList(this.m_visibleIndexes.length);
        int[] nArray = this.m_visibleIndexes;
        int n = this.m_visibleIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int m_visibleIndexe = nArray[n2];
            a.add(this.getColumn(m_visibleIndexe));
            ++n2;
        }
        return a;
    }

    public IColumn getFirstVisibleColumn() {
        if (this.m_visibleIndexes.length > 0) {
            return this.m_columns.get(this.m_visibleIndexes[0]);
        }
        return null;
    }

    public IColumn getFirstDefinedVisibileColumn() {
        int colIdx = this.m_columns.size();
        int[] nArray = this.m_visibleIndexes;
        int n = this.m_visibleIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int m_visibleIndexe = nArray[n2];
            if (Integer.compare(m_visibleIndexe, colIdx) < 0) {
                colIdx = m_visibleIndexe;
            }
            ++n2;
        }
        if (colIdx != this.m_columns.size()) {
            return this.m_columns.get(colIdx);
        }
        return null;
    }

    public List<IColumn<?>> getSummaryColumns() {
        ArrayList summaryColumns = new ArrayList();
        for (IColumn<?> c : this.getColumns()) {
            if (!c.isSummary()) continue;
            summaryColumns.add(c);
        }
        return summaryColumns;
    }

    public int getIndexFor(IColumn column) {
        return this.m_columns.indexOf(column);
    }

    public void moveColumnToVisibleIndex(int fromIndex, int toVisibleIndex) {
        int fromVisibleIndex = this.modelToVisibleIndex(fromIndex);
        if (fromVisibleIndex >= 0 && toVisibleIndex >= 0) {
            this.moveVisibleColumnToVisibleIndex(fromVisibleIndex, toVisibleIndex);
        }
    }

    public void moveVisibleColumnToVisibleIndex(int fromVisibleIndex, int toVisibleIndex) {
        if (fromVisibleIndex != toVisibleIndex) {
            IColumn fromCol = this.getVisibleColumn(fromVisibleIndex);
            IColumn toCol = this.getVisibleColumn(toVisibleIndex);
            if (fromCol != null && toCol != null) {
                boolean traversedFrom = false;
                ArrayList list = new ArrayList();
                for (IColumn<?> c : this.getAllColumnsInUserOrder()) {
                    if (c == fromCol) {
                        traversedFrom = true;
                        continue;
                    }
                    if (c == toCol) {
                        if (traversedFrom) {
                            list.add(c);
                            list.add(fromCol);
                            continue;
                        }
                        list.add(fromCol);
                        list.add(c);
                        continue;
                    }
                    list.add(c);
                }
                int viewHint = 0;
                for (IColumn iColumn : list) {
                    iColumn.setVisibleColumnIndexHint(viewHint);
                    ++viewHint;
                }
                this.reorganizeIndexes();
                this.fireColumnOrderChanged();
            }
        }
    }

    public void setVisibleColumns(Collection<? extends IColumn> columns) {
        try {
            this.m_table.setTableChanging(true);
            List<IColumn<?>> resolvedColumns = this.resolveColumns(columns);
            if (columns == null) {
                columns = CollectionUtility.hashSet((Object[])new IColumn[0]);
            }
            if (!resolvedColumns.isEmpty() || columns.isEmpty()) {
                ArrayList<IColumn> newColumns = new ArrayList<IColumn>();
                for (IColumn col : columns) {
                    if (!col.isDisplayable()) continue;
                    if (col.getInitialWidth() == 0 && col.getWidth() == 0) {
                        col.setInitialWidth(60);
                        col.setWidth(60);
                    }
                    newColumns.add(col);
                }
                int viewHint = 0;
                int nextNewIndex = 0;
                for (IColumn<?> col : this.getAllColumnsInUserOrder()) {
                    if (newColumns.contains(col)) {
                        IColumn nextSortedCol = (IColumn)newColumns.get(nextNewIndex);
                        ++nextNewIndex;
                        nextSortedCol.setVisible(true);
                        nextSortedCol.setVisibleColumnIndexHint(viewHint);
                    } else {
                        col.setVisible(false);
                        col.setVisibleColumnIndexHint(viewHint);
                    }
                    ++viewHint;
                }
                this.reorganizeIndexes();
                List<IColumn<?>> displayableColumns = this.getDisplayableColumns();
                for (IColumn<?> col : displayableColumns) {
                    this.rebuildHeaderCell(col);
                }
                this.fireColumnHeadersUpdated(displayableColumns);
                this.fireColumnStructureChanged();
                this.checkMultiline();
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    private int modelToVisibleIndex(int index) {
        int i = 0;
        while (i < this.m_visibleIndexes.length) {
            if (this.m_visibleIndexes[i] == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IColumn resolveColumn(IColumn c) {
        if (c.getTable() == this.m_table) {
            return c;
        }
        return null;
    }

    public List<IColumn<?>> resolveColumns(Collection<? extends IColumn> columns) {
        if (columns != null) {
            ArrayList result = new ArrayList(columns.size());
            for (IColumn iColumn : columns) {
                IColumn resolvedCol = this.resolveColumn(iColumn);
                if (resolvedCol == null) continue;
                result.add(resolvedCol);
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    public void handleSortEvent(IColumn col, boolean multiSort, boolean ascending) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        try {
            this.m_table.setTableChanging(true);
            if (multiSort) {
                if (this.isSortColumn(col)) {
                    this.updateSortColumn(col, ascending);
                } else {
                    this.addSortColumn(col, ascending);
                }
            } else {
                for (IColumn<?> c : this.m_userSortColumns) {
                    if (c == col) continue;
                    ((HeaderCell)c.getHeaderCell()).setGroupingActive(false);
                }
                if (this.isSortColumn(col) && this.getSortColumnCount() == 1) {
                    this.updateSortColumn(col, ascending);
                } else {
                    this.setSortColumn(col, ascending);
                    ((HeaderCell)col.getHeaderCell()).setGroupingActive(false);
                }
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    public boolean isUserColumnGroupingAllowed() {
        for (IColumn<?> col : this.getPermanentHeadSortColumns()) {
            if (col.isVisible() && col.isGroupingActive()) continue;
            return false;
        }
        return true;
    }

    public boolean isGroupingAllowed(IColumn<?> col) {
        if (this.isPermanentTailSortColumn(col)) {
            return false;
        }
        for (IColumn<?> other : this.getPermanentHeadSortColumns()) {
            if (other == col) {
                return col.isVisible();
            }
            if (other.isVisible() && other.isGroupingActive()) continue;
            return false;
        }
        return col.isVisible();
    }

    public void onGroupedColumnInvisible(IColumn<?> col) {
        this.m_table.setTableChanging(true);
        try {
            if (!this.isGroupingColumn(col) || col.isVisible()) {
                return;
            }
            this.removeGroupColumn(col);
            this.m_table.onGroupedColumnInvisible(col);
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    public boolean isGroupingColumn(IColumn<?> col) {
        IColumn rCol = this.resolveColumn(col);
        return rCol != null && this.isSortColumn(rCol) && rCol.isGroupingActive();
    }

    public void updateGroupingColumn(IColumn<?> col, boolean ascending) {
        if (!this.isGroupingColumn(col = this.resolveColumn(col)) || col.isSortPermanent()) {
            return;
        }
        HeaderCell cell = (HeaderCell)col.getHeaderCell();
        cell.setSortAscending(ascending);
        this.rebuildHeaderCell(col);
        this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
    }

    public void addGroupingColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        if (!this.isGroupingAllowed(col)) {
            return;
        }
        if (this.isPermanentHeadSortColumn(col)) {
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setGroupingActive(true);
            this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
            return;
        }
        this.m_userSortColumns.remove(col);
        int index = 0;
        for (IColumn<?> column : this.m_userSortColumns) {
            if (!column.isGroupingActive()) break;
            ++index;
        }
        if (!this.isSortColumn(col)) {
            this.m_userSortColumns.add(index, col);
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(true);
            cell.setSortAscending(ascending);
            cell.setGroupingActive(true);
            this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
        }
    }

    public void setGroupingColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        if (!this.isGroupingAllowed(col)) {
            return;
        }
        this.m_userSortColumns.remove(col);
        ArrayList toBeRemoved = new ArrayList();
        for (IColumn<?> iColumn : this.getSortColumns()) {
            if (!iColumn.isGroupingActive()) continue;
            toBeRemoved.add(iColumn);
        }
        for (IColumn<Object> iColumn : toBeRemoved) {
            this.removeGroupColumn(iColumn);
        }
        if (!this.isSortColumn(col)) {
            this.m_userSortColumns.add(0, col);
            HeaderCell headerCell = (HeaderCell)col.getHeaderCell();
            headerCell.setSortActive(true);
            headerCell.setSortAscending(ascending);
            headerCell.setGroupingActive(true);
        } else if (this.isPermanentHeadSortColumn(col)) {
            HeaderCell headerCell = (HeaderCell)col.getHeaderCell();
            headerCell.setGroupingActive(true);
        }
        this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
    }

    public void handleGroupingEvent(IColumn col, boolean multiGroup, boolean ascending) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        if (!this.isGroupingAllowed(col)) {
            return;
        }
        try {
            this.m_table.setTableChanging(true);
            if (multiGroup) {
                if (col.isGroupingActive()) {
                    this.updateGroupingColumn(col, ascending);
                } else {
                    this.addGroupingColumn(col, ascending);
                }
            } else {
                this.setGroupingColumn(col, ascending);
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    public void removeGroupColumn(IColumn<?> col) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        if (this.isPermanentHeadSortColumn(col)) {
            ArrayList toBeRemoved = new ArrayList();
            boolean after = false;
            for (IColumn<?> iColumn : this.getSortColumns()) {
                if (iColumn == col) {
                    after = true;
                }
                if (!after) continue;
                ((HeaderCell)iColumn.getHeaderCell()).setGroupingActive(false);
                toBeRemoved.add(iColumn);
            }
            for (IColumn<Object> iColumn : toBeRemoved) {
                this.removeSortColumn(iColumn);
            }
        } else {
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setGroupingActive(false);
            this.removeSortColumn(col);
        }
    }

    public void setAggregationFunction(INumberColumn<?> col, String f) {
        col.setAggregationFunction(f);
    }

    public int getSortColumnCount() {
        return this.m_userSortColumns.size() + this.m_permanentHeadSortColumns.size() + this.m_permanentTailSortColumns.size();
    }

    public List<IColumn<?>> getSortColumns() {
        ArrayList list = new ArrayList(this.getSortColumnCount());
        list.addAll(this.m_permanentHeadSortColumns);
        list.addAll(this.m_userSortColumns);
        list.addAll(this.m_permanentTailSortColumns);
        return list;
    }

    public List<IColumn<?>> getUserSortColumns() {
        return CollectionUtility.arrayList(this.m_userSortColumns);
    }

    public int getGroupedColumnCount() {
        return this.getGroupedColumns().size();
    }

    public List<IColumn<?>> getGroupedColumns() {
        ArrayList result = new ArrayList();
        for (IColumn<?> c : this.getSortColumns()) {
            if (!c.isGroupingActive()) continue;
            result.add(c);
        }
        return result;
    }

    public List<IColumn<?>> getPermanentHeadSortColumns() {
        return CollectionUtility.arrayList(this.m_permanentHeadSortColumns);
    }

    public List<IColumn<?>> getPermanentTailSortColumns() {
        return CollectionUtility.arrayList(this.m_permanentTailSortColumns);
    }

    public SortSpec getSortSpec() {
        ArrayList sortColumns = new ArrayList();
        sortColumns.addAll(this.getSortColumns());
        if (!sortColumns.isEmpty()) {
            int[] indexes = new int[sortColumns.size()];
            boolean[] asc = new boolean[sortColumns.size()];
            int i = 0;
            while (i < sortColumns.size()) {
                indexes[i] = ((IColumn)sortColumns.get(i)).getColumnIndex();
                asc[i] = ((IColumn)sortColumns.get(i)).isSortAscending();
                ++i;
            }
            return new SortSpec(indexes, asc);
        }
        return null;
    }

    public void setSortSpec(SortSpec spec) {
        if (spec != null) {
            for (IColumn<?> col : this.m_userSortColumns) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(false);
                cell.setSortAscending(false);
            }
            this.m_userSortColumns.clear();
            ArrayList<IColumn> colList = new ArrayList<IColumn>();
            int i = 0;
            while (i < spec.size()) {
                IColumn col = this.getColumn(spec.getColumnIndex(i));
                if (col != null && !this.isSortColumn(col)) {
                    HeaderCell cell = (HeaderCell)col.getHeaderCell();
                    cell.setSortActive(true);
                    cell.setSortAscending(spec.isColumnAscending(i));
                    colList.add(col);
                }
                ++i;
            }
            this.m_userSortColumns.addAll(colList);
            for (IColumn col : colList) {
                this.rebuildHeaderCell(col);
            }
            this.fireColumnHeadersUpdated(colList);
        } else {
            this.clearSortColumns();
        }
    }

    public boolean isSortColumn(IColumn col) {
        return this.m_permanentHeadSortColumns.contains(col) || this.m_userSortColumns.contains(col) || this.m_permanentTailSortColumns.contains(col);
    }

    public boolean isUserSortColumn(IColumn col) {
        return this.m_userSortColumns.contains(col);
    }

    public boolean isPermanentHeadSortColumn(IColumn col) {
        return this.m_permanentHeadSortColumns.contains(col);
    }

    public boolean isPermanentTailSortColumn(IColumn col) {
        return this.m_permanentTailSortColumns.contains(col);
    }

    public int getSortColumnIndex(IColumn col) {
        if (this.isPermanentHeadSortColumn(col)) {
            return this.m_permanentHeadSortColumns.indexOf(col);
        }
        if (this.isUserSortColumn(col)) {
            return this.m_permanentHeadSortColumns.size() + this.m_userSortColumns.indexOf(col);
        }
        if (this.isPermanentTailSortColumn(col)) {
            return this.m_permanentHeadSortColumns.size() + this.m_userSortColumns.size() + this.m_permanentTailSortColumns.indexOf(col);
        }
        return -1;
    }

    public void setSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.clearSortColumns();
            if (!this.isSortColumn(col)) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(true);
                cell.setSortAscending(ascending);
                cell.setGroupingActive(false);
                this.m_userSortColumns.add(col);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
            }
        }
    }

    public void addSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(true);
                cell.setSortAscending(ascending);
                this.m_userSortColumns.add(col);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
            }
        }
    }

    public void updateSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) == null || !this.isSortColumn(col) || col.isSortPermanent() || col.isSortAscending() == ascending) {
            return;
        }
        HeaderCell cell = (HeaderCell)col.getHeaderCell();
        cell.setSortAscending(ascending);
        this.rebuildHeaderCell(col);
        this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
    }

    private void updateColumnStructure(IColumn column) {
        this.reorganizeIndexes();
        this.checkMultiline();
        this.fireColumnStructureChanged();
    }

    private void resetColumnsViewOrder() {
        for (IColumn<?> c : this.getColumns()) {
            c.setVisibleColumnIndexHint(-1);
        }
        this.reorganizeIndexes();
        this.fireColumnOrderChanged();
    }

    public void updateColumn(IColumn<?> column) {
        this.checkMultiline();
        this.fireColumnHeadersUpdated(CollectionUtility.hashSet(column));
    }

    public void removeSortColumn(IColumn<?> col) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        this.m_table.setTableChanging(true);
        try {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(false);
                cell.setGroupingActive(false);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    public void clearSortColumns() {
        if (this.m_userSortColumns.isEmpty()) {
            return;
        }
        ArrayList userSortColumnsBackup = new ArrayList(this.m_userSortColumns);
        this.m_userSortColumns.clear();
        for (IColumn iColumn : userSortColumnsBackup) {
            HeaderCell cell = (HeaderCell)iColumn.getHeaderCell();
            cell.setSortActive(false);
            cell.setGroupingActive(false);
        }
        for (IColumn iColumn : userSortColumnsBackup) {
            this.rebuildHeaderCell(iColumn);
        }
        this.fireColumnHeadersUpdated(userSortColumnsBackup);
    }

    public void clearPermanentHeadSortColumns() {
        if (this.m_permanentHeadSortColumns.isEmpty()) {
            return;
        }
        ArrayList currentColumnList = new ArrayList(this.m_permanentHeadSortColumns);
        this.m_permanentHeadSortColumns.clear();
        for (IColumn iColumn : currentColumnList) {
            HeaderCell cell = (HeaderCell)iColumn.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortPermanent(false);
            cell.setGroupingActive(false);
        }
        for (IColumn iColumn : currentColumnList) {
            this.rebuildHeaderCell(iColumn);
        }
        this.fireColumnHeadersUpdated(currentColumnList);
    }

    public void clearPermanentTailSortColumns() {
        if (this.m_permanentTailSortColumns.isEmpty()) {
            return;
        }
        ArrayList currentColumnList = new ArrayList(this.m_permanentTailSortColumns);
        this.m_permanentTailSortColumns.clear();
        for (IColumn iColumn : currentColumnList) {
            HeaderCell cell = (HeaderCell)iColumn.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortPermanent(false);
            cell.setGroupingActive(false);
        }
        for (IColumn iColumn : currentColumnList) {
            this.rebuildHeaderCell(iColumn);
        }
        this.fireColumnHeadersUpdated(currentColumnList);
    }

    public void addPermanentHeadSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_permanentHeadSortColumns.remove(col);
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(true);
            cell.setSortPermanent(true);
            cell.setSortAscending(ascending);
            this.m_permanentHeadSortColumns.add(col);
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
        }
    }

    public void addPermanentTailSortColumn(IColumn<?> col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_permanentTailSortColumns.remove(col);
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(true);
            cell.setSortPermanent(true);
            cell.setSortAscending(ascending);
            this.m_permanentTailSortColumns.add(col);
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(CollectionUtility.hashSet((Object)col));
        }
    }

    private void reorganizeIndexes() {
        this.calculateDisplayableIndexes();
        this.calculateVisibleIndexes();
        this.calculateKeyIndexes();
        this.calculateParentKeyIndexes();
    }

    private void calculateDisplayableIndexes() {
        int viewIndex = 0;
        TreeMap<CompositeObject, Integer> displayableMap = new TreeMap<CompositeObject, Integer>();
        int modelIndex = 0;
        while (modelIndex < this.getColumnCount()) {
            IColumn col = this.getColumn(modelIndex);
            if (col.isDisplayable()) {
                displayableMap.put(new CompositeObject(new Object[]{modelIndex}), modelIndex);
            }
            ++modelIndex;
        }
        this.m_displayableIndexes = new int[displayableMap.size()];
        viewIndex = 0;
        Iterator iterator = displayableMap.values().iterator();
        while (iterator.hasNext()) {
            modelIndex = (Integer)iterator.next();
            this.m_displayableIndexes[viewIndex++] = modelIndex;
        }
    }

    private void calculateVisibleIndexes() {
        int viewIndex = 0;
        TreeMap<CompositeObject, Integer> visibleMap = new TreeMap<CompositeObject, Integer>();
        int modelIndex = 0;
        while (modelIndex < this.getColumnCount()) {
            IColumn col = this.getColumn(modelIndex);
            if (col.isDisplayable() && col.isVisible()) {
                double viewHint = col.getVisibleColumnIndexHint();
                if (viewHint < 0.0) {
                    viewHint = col.getOrder();
                }
                if (viewHint < 0.0) {
                    viewHint = viewIndex;
                }
                visibleMap.put(new CompositeObject(new Object[]{viewHint, viewIndex}), modelIndex);
                ++viewIndex;
            }
            ++modelIndex;
        }
        this.m_visibleIndexes = new int[visibleMap.size()];
        viewIndex = 0;
        Iterator iterator = visibleMap.values().iterator();
        while (iterator.hasNext()) {
            modelIndex = (Integer)iterator.next();
            this.m_visibleIndexes[viewIndex++] = modelIndex;
        }
    }

    private void calculateKeyIndexes() {
        ArrayList<Integer> keyIndexes = new ArrayList<Integer>();
        int modelIndex = 0;
        while (modelIndex < this.getColumnCount()) {
            IColumn col = this.getColumn(modelIndex);
            if (col.isPrimaryKey()) {
                keyIndexes.add(modelIndex);
            }
            ++modelIndex;
        }
        this.m_keyIndexes = new int[keyIndexes.size()];
        int viewIndex = 0;
        Iterator iterator = keyIndexes.iterator();
        while (iterator.hasNext()) {
            int modelIndex2 = (Integer)iterator.next();
            this.m_keyIndexes[viewIndex++] = modelIndex2;
        }
    }

    private void calculateParentKeyIndexes() {
        ArrayList<Integer> keyIndexes = new ArrayList<Integer>();
        int modelIndex = 0;
        while (modelIndex < this.getColumnCount()) {
            IColumn col = this.getColumn(modelIndex);
            if (col.isParentKey()) {
                keyIndexes.add(modelIndex);
            }
            ++modelIndex;
        }
        this.m_parentKeyIndexes = new int[keyIndexes.size()];
        int viewIndex = 0;
        Iterator iterator = keyIndexes.iterator();
        while (iterator.hasNext()) {
            int modelIndex2 = (Integer)iterator.next();
            this.m_parentKeyIndexes[viewIndex++] = modelIndex2;
        }
    }

    private void rebuildHeaderCell(IColumn col) {
        col.decorateHeaderCell();
    }

    private void fireColumnHeadersUpdated(Collection<? extends IColumn<?>> columns) {
        TableEvent e = new TableEvent(this.m_table, 780);
        e.setColumns(columns);
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnOrderChanged() {
        TableEvent e = new TableEvent(this.m_table, 770);
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnAggregationChanged(IColumn<?> c) {
        Assertions.assertInstance(c, INumberColumn.class, (String)"ColumnAggregation is only supported on NumberColumns.", (Object[])new Object[0]);
        TableEvent e = new TableEvent(this.m_table, 950);
        e.setColumns(CollectionUtility.arrayList(c));
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnBackgroundEffectChanged(IColumn<?> c) {
        Assertions.assertInstance(c, INumberColumn.class, (String)"BackgroundEffect is only supported on NumberColumns.", (Object[])new Object[0]);
        TableEvent e = new TableEvent(this.m_table, 960);
        e.setColumns(CollectionUtility.arrayList(c));
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnStructureChanged() {
        TableEvent e = new TableEvent(this.m_table, 1);
        this.m_table.fireTableEventInternal(e);
    }

    private void checkMultiline() {
        if (this.m_table != null && !this.m_table.isInitialMultilineText() && !ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"getConfiguredMultilineText", null, this.m_table.getClass())) {
            boolean m = false;
            for (IColumn<?> col : this.getVisibleColumns()) {
                if (!(col instanceof IStringColumn) || !((IStringColumn)col).isTextWrap()) continue;
                m = true;
                break;
            }
            this.m_table.setMultilineText(m);
        }
    }

    private class P_ColumnListener
    implements PropertyChangeListener {
        private P_ColumnListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            IColumn c = (IColumn)e.getSource();
            if ("viewColumnIndexHint".equals(e.getPropertyName())) {
                return;
            }
            if ("order".equals(e.getPropertyName())) {
                ColumnSet.this.resetColumnsViewOrder();
                return;
            }
            if ("aggregationFunction".equals(e.getPropertyName())) {
                ColumnSet.this.fireColumnAggregationChanged(c);
                return;
            }
            if ("backgroundEffect".equals(e.getPropertyName())) {
                ColumnSet.this.fireColumnBackgroundEffectChanged(c);
                return;
            }
            if (c.isGroupingActive() && "visible".equals(e.getPropertyName())) {
                ColumnSet.this.onGroupedColumnInvisible(c);
            }
            ColumnSet.this.updateColumnStructure(c);
        }
    }

    private static class P_SortingAndGroupingConfig {
        private int m_sortIndex;
        private boolean m_ascending;
        private boolean m_grouped;
        private String m_aggregationFunction;

        private P_SortingAndGroupingConfig() {
        }

        public int getSortIndex() {
            return this.m_sortIndex;
        }

        public void setSortIndex(int sortIndex) {
            this.m_sortIndex = sortIndex;
        }

        public boolean isAscending() {
            return this.m_ascending;
        }

        public void setAscending(boolean ascending) {
            this.m_ascending = ascending;
        }

        public boolean isGrouped() {
            return this.m_grouped;
        }

        public void setGrouped(boolean grouped) {
            this.m_grouped = grouped;
        }

        public String getAggregationFunction() {
            return this.m_aggregationFunction;
        }

        public void setAggregationFunction(String aggregationFunction) {
            this.m_aggregationFunction = aggregationFunction;
        }
    }
}

