/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IUserFilterState;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEvent
extends EventObject
implements IModelEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TableEvent.class);
    public static final int TYPE_COLUMN_STRUCTURE_CHANGED = 1;
    public static final int TYPE_ROWS_INSERTED = 100;
    public static final int TYPE_ROWS_UPDATED = 101;
    public static final int TYPE_ROWS_DELETED = 102;
    public static final int TYPE_ROWS_SELECTED = 103;
    public static final int TYPE_ROW_ACTION = 104;
    public static final int TYPE_ALL_ROWS_DELETED = 105;
    public static final int TYPE_ROW_ORDER_CHANGED = 200;
    public static final int TYPE_ROW_FILTER_CHANGED = 210;
    public static final int TYPE_ROWS_DRAG_REQUEST = 730;
    public static final int TYPE_ROW_DROP_ACTION = 740;
    public static final int TYPE_ROWS_COPY_REQUEST = 760;
    public static final int TYPE_COLUMN_ORDER_CHANGED = 770;
    public static final int TYPE_COLUMN_HEADERS_UPDATED = 780;
    public static final int TYPE_REQUEST_FOCUS = 800;
    public static final int TYPE_REQUEST_FOCUS_IN_CELL = 805;
    public static final int TYPE_START_CELL_EDIT = 807;
    public static final int TYPE_END_CELL_EDIT = 808;
    public static final int TYPE_ROW_CLICK = 810;
    public static final int TYPE_SCROLL_TO_SELECTION = 830;
    public static final int TYPE_ROWS_CHECKED = 850;
    public static final int TYPE_ROWS_EXPANDED = 860;
    public static final int TYPE_USER_FILTER_ADDED = 900;
    public static final int TYPE_USER_FILTER_REMOVED = 910;
    public static final int TYPE_COLUMN_AGGREGATION_CHANGED = 950;
    public static final int TYPE_COLUMN_BACKGROUND_EFFECT_CHANGED = 960;
    private final int m_type;
    private List<? extends ITableRow> m_rows;
    private List<IMenu> m_popupMenus;
    private boolean m_consumed;
    private TransferObject m_dragObject;
    private TransferObject m_dropObject;
    private TransferObject m_copyObject;
    private Collection<? extends IColumn<?>> m_columns;
    private Map<ITableRow, Set<IColumn<?>>> m_updatedColumns;
    private boolean m_sortInMemoryAllowed;
    private IUserFilterState m_userFilter;
    private IFormField m_cellEditor;

    public TableEvent(ITable source, int type) {
        this(source, type, (ITableRow)null);
    }

    public TableEvent(ITable source, int type, ITableRow row) {
        this(source, type, CollectionUtility.arrayList((Object)row));
    }

    public TableEvent(ITable source, int type, List<? extends ITableRow> rows) {
        super(source);
        this.m_type = type;
        this.m_rows = CollectionUtility.arrayList(rows);
    }

    public ITable getTable() {
        return (ITable)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public List<ITableRow> getRows() {
        return CollectionUtility.arrayList(this.m_rows);
    }

    public void setRows(List<? extends ITableRow> rows) {
        this.m_rows = CollectionUtility.arrayList(rows);
    }

    public Set<ITableRow> getRowsSet() {
        return CollectionUtility.hashSet(this.m_rows);
    }

    public boolean removeRow(ITableRow row) {
        if (row == null || this.m_rows.isEmpty()) {
            return false;
        }
        return this.removeRows(Collections.singleton(row), null);
    }

    public boolean removeRows(Collection<ITableRow> rowsToRemove) {
        return this.removeRows(rowsToRemove, null);
    }

    public boolean removeRows(Collection<ITableRow> rowsToRemove, Set<ITableRow> removedRowsCollector) {
        if (CollectionUtility.isEmpty(rowsToRemove) || this.m_rows.isEmpty()) {
            return false;
        }
        boolean removed = false;
        Iterator<? extends ITableRow> it = this.m_rows.iterator();
        while (it.hasNext()) {
            ITableRow row = it.next();
            if (!rowsToRemove.contains(row)) continue;
            it.remove();
            removed = true;
            if (removedRowsCollector == null) continue;
            removedRowsCollector.add(row);
        }
        return removed;
    }

    public void clearRows() {
        this.m_rows.clear();
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public boolean hasRows() {
        return !this.m_rows.isEmpty();
    }

    public boolean containsRow(ITableRow row) {
        return this.m_rows.contains(row);
    }

    public ITableRow getFirstRow() {
        return (ITableRow)CollectionUtility.firstElement(this.m_rows);
    }

    public ITableRow getLastRow() {
        return (ITableRow)CollectionUtility.lastElement(this.m_rows);
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(menus);
        }
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    public boolean isConsumed() {
        return this.m_consumed;
    }

    public void consume() {
        this.m_consumed = true;
    }

    public TransferObject getDragObject() {
        return this.m_dragObject;
    }

    public void setDragObject(TransferObject t) {
        this.m_dragObject = t;
    }

    public TransferObject getDropObject() {
        return this.m_dropObject;
    }

    public void setDropObject(TransferObject t) {
        this.m_dropObject = t;
    }

    public TransferObject getCopyObject() {
        return this.m_copyObject;
    }

    public void setCopyObject(TransferObject t) {
        this.m_copyObject = t;
    }

    public Collection<IColumn<?>> getColumns() {
        return CollectionUtility.arrayList(this.m_columns);
    }

    public IColumn getFirstColumn() {
        return (IColumn)CollectionUtility.firstElement(this.m_columns);
    }

    public void setColumns(Collection<? extends IColumn<?>> columns) {
        this.m_columns = columns;
    }

    public void setUpdatedColumns(ITableRow row, Set<IColumn<?>> updateColumns) {
        if (this.m_updatedColumns == null) {
            this.m_updatedColumns = new HashMap();
        }
        this.m_updatedColumns.put(row, updateColumns);
    }

    public Map<ITableRow, Set<IColumn<?>>> getUpdatedColumns() {
        if (this.m_updatedColumns == null) {
            return new HashMap();
        }
        return new HashMap(this.m_updatedColumns);
    }

    public Set<IColumn<?>> getUpdatedColumns(ITableRow row) {
        return CollectionUtility.hashSet(this.m_updatedColumns == null ? null : (Collection)this.m_updatedColumns.get(row));
    }

    public void setUserFilter(IUserFilterState userFilter) {
        this.m_userFilter = userFilter;
    }

    public IUserFilterState getUserFilter() {
        return this.m_userFilter;
    }

    public void setCellEditor(IFormField cellEditor) {
        this.m_cellEditor = cellEditor;
    }

    public IFormField getCellEditor() {
        return this.m_cellEditor;
    }

    public boolean isSortInMemoryAllowed() {
        return this.m_sortInMemoryAllowed;
    }

    public void setSortInMemoryAllowed(boolean b) {
        this.m_sortInMemoryAllowed = b;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        buf.append(this.getTypeName());
        if (CollectionUtility.hasElements(this.m_rows) && this.getTable() != null) {
            buf.append(" ");
            if (this.m_rows.size() == 1) {
                buf.append("row ").append(this.m_rows.get(0));
            } else {
                buf.append("rows {");
                Iterator<? extends ITableRow> rowIt = this.m_rows.iterator();
                buf.append("").append(rowIt.next());
                while (rowIt.hasNext()) {
                    buf.append(",");
                    buf.append("").append(rowIt.next());
                }
                buf.append("}");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    protected String getTypeName() {
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    return aF.getName();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Error Reading fields", (Throwable)e);
        }
        return "#" + this.m_type;
    }
}

