/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;

public class TableRow
implements ITableRow {
    private static final String CHECKED = "CHECKED";
    protected static final String EXPANDED = "EXPANDED";
    private static final String ROW_PROPERTIES_CHANGED = "ROW_PROPERTIES_CHANGED";
    protected static final String REJECTED_BY_USER = "REJECTED_BY_USER";
    protected static final String FILTER_ACCEPTED = "FILTER_ACCEPTED";
    protected static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"CHECKED", "EXPANDED", "ENABLED", "ROW_PROPERTIES_CHANGED", "REJECTED_BY_USER", "FILTER_ACCEPTED"});
    private final Object m_childRowListLock = new Object();
    private List<ITableRow> m_childRowList = new ArrayList<ITableRow>();
    private final ColumnSet m_columnSet;
    private final Map<String, Object> m_customValues;
    protected final List<Cell> m_cells;
    protected byte m_flags;
    private int m_status = 0;
    private String m_iconId;
    private String m_cssClass;
    private Set<Integer> m_updatedColumnIndexes;
    private ITableRow m_parentRow;

    public TableRow(ColumnSet columnSet) {
        this.m_columnSet = columnSet;
        this.m_customValues = new HashMap<String, Object>(0);
        int colCount = columnSet != null ? columnSet.getColumnCount() : 0;
        this.m_cells = new ArrayList<Cell>(colCount);
        this.setEnabled(true);
        this.addCells(colCount);
    }

    public TableRow(ColumnSet columnSet, ITableRow row) {
        this.m_columnSet = columnSet;
        this.m_customValues = new HashMap<String, Object>(row.getCustomValues());
        int colCount = columnSet != null ? columnSet.getColumnCount() : 0;
        this.m_cells = new ArrayList<Cell>(colCount);
        this.setEnabled(true);
        this.copyCells(row);
    }

    public TableRow(ColumnSet columnSet, List<?> values) {
        this(columnSet);
        if (CollectionUtility.hasElements(values)) {
            int i = 0;
            while (i < values.size()) {
                Cell cell = this.getCellForUpdate(i);
                cell.setValue(values.get(i));
                ++i;
            }
        }
    }

    private void addCells(int colCount) {
        int i = 0;
        while (i < colCount) {
            this.m_cells.add(new Cell());
            ++i;
        }
    }

    private void copyCells(ITableRow row) {
        int i = 0;
        while (i < row.getCellCount()) {
            this.m_cells.add(new Cell(row.getCell(i)));
            ++i;
        }
    }

    @Override
    public int getRowIndex() {
        return -1;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public boolean isStatusInserted() {
        return this.m_status == 1;
    }

    @Override
    public void setStatusInserted() {
        this.setStatus(1);
    }

    @Override
    public boolean isStatusUpdated() {
        return this.m_status == 2;
    }

    @Override
    public void setStatusUpdated() {
        this.setStatus(2);
    }

    @Override
    public boolean isStatusDeleted() {
        return this.m_status == 3;
    }

    @Override
    public void setStatusDeleted() {
        this.setStatus(3);
    }

    @Override
    public boolean isStatusNonchanged() {
        return this.m_status == 0;
    }

    @Override
    public void setStatusNonchanged() {
        this.setStatus(0);
    }

    @Override
    public boolean isEnabled() {
        return FLAGS_BIT_HELPER.isBitSet("ENABLED", this.m_flags);
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit("ENABLED", b, this.m_flags);
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean isChecked() {
        return FLAGS_BIT_HELPER.isBitSet(CHECKED, this.m_flags);
    }

    @Override
    public void setChecked(boolean checked) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(CHECKED, checked, this.m_flags);
    }

    @Override
    public boolean isExpanded() {
        return FLAGS_BIT_HELPER.isBitSet(EXPANDED, this.m_flags);
    }

    @Override
    public boolean setExpanded(boolean expanded) {
        boolean changed = expanded ^ this.isExpanded();
        if (changed) {
            this.m_flags = FLAGS_BIT_HELPER.changeBit(EXPANDED, expanded, this.m_flags);
        }
        return changed;
    }

    @Override
    public boolean isFilterAccepted() {
        return true;
    }

    @Override
    public boolean isRejectedByUser() {
        return false;
    }

    @Override
    public int getCellCount() {
        return this.m_cells.size();
    }

    @Override
    public ICell getCell(IColumn column) {
        return this.getCell(column.getColumnIndex());
    }

    @Override
    public ICell getCell(int columnIndex) {
        if (columnIndex < this.m_cells.size()) {
            return this.m_cells.get(columnIndex);
        }
        return null;
    }

    @Override
    public void setCell(IColumn column, ICell cell) {
        this.setCell(column.getColumnIndex(), cell);
    }

    @Override
    public void setCell(int columnIndex, ICell cell) {
        if (cell != null) {
            this.getCellForUpdate(columnIndex);
            this.m_cells.set(columnIndex, new Cell(null, cell));
        }
    }

    @Override
    public Cell getCellForUpdate(IColumn column) {
        return this.getCellForUpdate(column.getColumnIndex());
    }

    @Override
    public Cell getCellForUpdate(int columnIndex) {
        while (columnIndex >= this.m_cells.size()) {
            this.m_cells.add(new Cell());
        }
        return this.m_cells.get(columnIndex);
    }

    @Override
    public Object getCellValue(int columnIndex) {
        ICell cell = this.getCell(columnIndex);
        if (cell != null) {
            return cell.getValue();
        }
        return null;
    }

    @Override
    public Object getCustomValue(String id) {
        return this.m_customValues.get(id);
    }

    @Override
    public Map<String, Object> getCustomValues() {
        return this.m_customValues;
    }

    @Override
    public void setCustomValue(String id, Object value) {
        this.m_customValues.put(id, value);
    }

    @Override
    public List<Object> getKeyValues() {
        if (this.m_columnSet == null) {
            throw new UnsupportedOperationException("can only be called when TableRow was constructed with a non-null columnSet");
        }
        int[] keyColumns = this.m_columnSet.getKeyColumnIndexes();
        if (keyColumns.length == 0) {
            keyColumns = this.m_columnSet.getAllColumnIndexes();
        }
        ArrayList<Object> pk = new ArrayList<Object>(keyColumns.length);
        int[] nArray = keyColumns;
        int n = keyColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int keyIndex = nArray[n2];
            pk.add(this.getCellValue(keyIndex));
            ++n2;
        }
        return pk;
    }

    @Override
    public List<Object> getParentKeyValues() {
        if (this.m_columnSet == null) {
            throw new UnsupportedOperationException("can only be called when TableRow was constructed with a non-null columnSet");
        }
        int[] keyColumns = this.m_columnSet.getParentKeyColumnIndexes();
        ArrayList<Object> pk = new ArrayList<Object>(keyColumns.length);
        int[] nArray = keyColumns;
        int n = keyColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int keyIndex = nArray[n2];
            pk.add(this.getCellValue(keyIndex));
            ++n2;
        }
        return pk;
    }

    @Override
    public boolean isRowChanging() {
        return false;
    }

    @Override
    public void setRowChanging(boolean b) {
    }

    @Override
    public boolean setCellValue(int columnIndex, Object value) {
        try {
            this.setRowChanging(true);
            Object oldValue = this.getCellValue(columnIndex);
            if (oldValue == value || oldValue != null && oldValue.equals(value)) {
                return false;
            }
            this.getCellForUpdate(columnIndex);
            this.m_cells.get(columnIndex).setValue(value);
            if (this.isStatusNonchanged()) {
                this.setStatusUpdated();
            }
            return true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public boolean setCellValues(List<?> values) {
        try {
            this.setRowChanging(true);
            boolean changed = false;
            int i = 0;
            while (i < values.size()) {
                boolean b = this.setCellValue(i, values.get(i));
                changed = changed || b;
                ++i;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public ITable getTable() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITableRow> getChildRows() {
        Object object = this.m_childRowListLock;
        synchronized (object) {
            return CollectionUtility.arrayList(this.m_childRowList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setChildRowsInternal(List<ITableRow> childRows) {
        Object object = this.m_childRowListLock;
        synchronized (object) {
            this.m_childRowList = childRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChildRowInternal(ITableRow row) {
        Object object = this.m_childRowListLock;
        synchronized (object) {
            this.m_childRowList.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChildRowInternal(ITableRow childRow) {
        Object object = this.m_childRowListLock;
        synchronized (object) {
            this.m_childRowList.remove(childRow);
        }
    }

    @Override
    public ITableRow getParentRow() {
        return this.m_parentRow;
    }

    @Override
    public final void setParentRowInternal(ITableRow parentRow) {
        this.m_parentRow = parentRow;
    }

    @Override
    public void touch() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void setBackgroundColor(String c) {
        for (Cell m_cell : this.m_cells) {
            m_cell.setBackgroundColor(c);
        }
    }

    @Override
    public void setForegroundColor(String c) {
        for (Cell m_cell : this.m_cells) {
            m_cell.setForegroundColor(c);
        }
    }

    @Override
    public void setCssClass(String cssClass) {
        this.m_cssClass = cssClass;
        for (Cell m_cell : this.m_cells) {
            m_cell.setCssClass(cssClass);
        }
    }

    @Override
    public String getCssClass() {
        return this.m_cssClass;
    }

    @Override
    public void setFont(FontSpec f) {
        for (Cell m_cell : this.m_cells) {
            m_cell.setFont(f);
        }
    }

    @Override
    public void setTooltipText(String s) {
        for (Cell m_cell : this.m_cells) {
            m_cell.setTooltipText(s);
        }
    }

    @Override
    public void setIconId(String iconId) {
        this.m_iconId = iconId;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void moveDown() {
    }

    @Override
    public void moveToBottom() {
    }

    @Override
    public void moveToTop() {
    }

    @Override
    public void moveUp() {
    }

    @Override
    public boolean isRowPropertiesChanged() {
        return FLAGS_BIT_HELPER.isBitSet(ROW_PROPERTIES_CHANGED, this.m_flags);
    }

    @Override
    public void setRowPropertiesChanged(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ROW_PROPERTIES_CHANGED, b, this.m_flags);
    }

    @Override
    public Set<Integer> getUpdatedColumnIndexes() {
        return CollectionUtility.hashSet(this.m_updatedColumnIndexes);
    }

    @Override
    public void setUpdatedColumnIndexes(Set<Integer> updatedColumnIndexes) {
        this.m_updatedColumnIndexes = updatedColumnIndexes;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.m_cells;
    }

    @Override
    public Set<Integer> getUpdatedColumnIndexes(int changedBit) {
        return Collections.emptySet();
    }
}

